package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.S_ENUM;
import io.ciera.tool.sql.ooaofooa.domain.impl.S_ENUMImpl;
import io.ciera.tool.sql.ooaofooa.value.LiteralEnumerator;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class LiteralEnumeratorImpl extends ModelInstance<LiteralEnumerator,Sql> implements LiteralEnumerator {

    public static final String KEY_LETTERS = "V_LEN";
    public static final LiteralEnumerator EMPTY_LITERALENUMERATOR = new EmptyLiteralEnumerator();

    private Sql context;

    // constructors
    private LiteralEnumeratorImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        ref_Enum_ID = UniqueId.random();
        m_dataTypeNameLineNumber = 0;
        m_dataTypeNameColumn = 0;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R824_has_value_S_ENUM_inst = S_ENUMImpl.EMPTY_S_ENUM;
    }

    private LiteralEnumeratorImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Enum_ID, int m_dataTypeNameLineNumber, int m_dataTypeNameColumn ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_Enum_ID = ref_Enum_ID;
        this.m_dataTypeNameLineNumber = m_dataTypeNameLineNumber;
        this.m_dataTypeNameColumn = m_dataTypeNameColumn;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R824_has_value_S_ENUM_inst = S_ENUMImpl.EMPTY_S_ENUM;
    }

    public static LiteralEnumerator create( Sql context ) throws XtumlException {
        LiteralEnumerator newLiteralEnumerator = new LiteralEnumeratorImpl( context );
        if ( context.addInstance( newLiteralEnumerator ) ) {
            newLiteralEnumerator.getRunContext().addChange(new InstanceCreatedDelta(newLiteralEnumerator, KEY_LETTERS));
            return newLiteralEnumerator;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static LiteralEnumerator create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Enum_ID, int m_dataTypeNameLineNumber, int m_dataTypeNameColumn ) throws XtumlException {
        LiteralEnumerator newLiteralEnumerator = new LiteralEnumeratorImpl( context, instanceId, ref_Value_ID, ref_Enum_ID, m_dataTypeNameLineNumber, m_dataTypeNameColumn );
        if ( context.addInstance( newLiteralEnumerator ) ) {
            return newLiteralEnumerator;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Value_ID.inequality( this.ref_Value_ID ) ) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
                return ref_Value_ID;
    }
    private UniqueId ref_Enum_ID;
    @Override
    public void setEnum_ID( UniqueId ref_Enum_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Enum_ID.inequality( this.ref_Enum_ID ) ) {
            final UniqueId oldValue = this.ref_Enum_ID;
            this.ref_Enum_ID = ref_Enum_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Enum_ID", oldValue, this.ref_Enum_ID));
        }
    }
    @Override
    public UniqueId getEnum_ID() throws XtumlException {
        checkLiving();
                return ref_Enum_ID;
    }
    private int m_dataTypeNameLineNumber;
    @Override
    public void setDataTypeNameLineNumber( int m_dataTypeNameLineNumber ) throws XtumlException {
        checkLiving();
        if ( m_dataTypeNameLineNumber != this.m_dataTypeNameLineNumber ) {
            final int oldValue = this.m_dataTypeNameLineNumber;
            this.m_dataTypeNameLineNumber = m_dataTypeNameLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_dataTypeNameLineNumber", oldValue, this.m_dataTypeNameLineNumber));
        }
    }
    @Override
    public int getDataTypeNameLineNumber() throws XtumlException {
        checkLiving();
                return m_dataTypeNameLineNumber;
    }
    private int m_dataTypeNameColumn;
    @Override
    public int getDataTypeNameColumn() throws XtumlException {
        checkLiving();
                return m_dataTypeNameColumn;
    }
    @Override
    public void setDataTypeNameColumn( int m_dataTypeNameColumn ) throws XtumlException {
        checkLiving();
        if ( m_dataTypeNameColumn != this.m_dataTypeNameColumn ) {
            final int oldValue = this.m_dataTypeNameColumn;
            this.m_dataTypeNameColumn = m_dataTypeNameColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_dataTypeNameColumn", oldValue, this.m_dataTypeNameColumn));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R801_is_a_Value_inst;
    @Override
    public void setR801_is_a_Value( Value inst ) {
        R801_is_a_Value_inst = inst;
    }
    @Override
    public Value R801_is_a_Value() throws XtumlException {
        return R801_is_a_Value_inst;
    }
    private S_ENUM R824_has_value_S_ENUM_inst;
    @Override
    public void setR824_has_value_S_ENUM( S_ENUM inst ) {
        R824_has_value_S_ENUM_inst = inst;
    }
    @Override
    public S_ENUM R824_has_value_S_ENUM() throws XtumlException {
        return R824_has_value_S_ENUM_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public LiteralEnumerator value() {
        return this;
    }

    @Override
    public LiteralEnumerator self() {
        return this;
    }

    @Override
    public LiteralEnumerator oneWhere( IWhere<LiteralEnumerator> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_LITERALENUMERATOR;
    }

}

class EmptyLiteralEnumerator extends ModelInstance<LiteralEnumerator,Sql> implements LiteralEnumerator {

    // attributes
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEnum_ID( UniqueId ref_Enum_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getEnum_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDataTypeNameLineNumber( int m_dataTypeNameLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getDataTypeNameLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getDataTypeNameColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDataTypeNameColumn( int m_dataTypeNameColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R801_is_a_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public S_ENUM R824_has_value_S_ENUM() {
        return S_ENUMImpl.EMPTY_S_ENUM;
    }


    @Override
    public String getKeyLetters() {
        return LiteralEnumeratorImpl.KEY_LETTERS;
    }

    @Override
    public LiteralEnumerator value() {
        return this;
    }
    
    @Override
    public LiteralEnumerator self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public LiteralEnumerator oneWhere( IWhere<LiteralEnumerator> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return LiteralEnumeratorImpl.EMPTY_LITERALENUMERATOR;
    }

}
