package io.ciera.tool.sql.ooaofooa.subsystem.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.domain.DataTypeSet;
import io.ciera.tool.sql.ooaofooa.domain.DimensionsSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DimensionsSetImpl;
import io.ciera.tool.sql.ooaofooa.message.OperationArgumentSet;
import io.ciera.tool.sql.ooaofooa.message.impl.OperationArgumentSetImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.O_TFRSet;
import io.ciera.tool.sql.ooaofooa.subsystem.OperationParameter;
import io.ciera.tool.sql.ooaofooa.subsystem.OperationParameterSet;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_TFRSetImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.OperationParameterSetImpl;
import io.ciera.tool.sql.ooaofooa.value.ParameterValueSet;
import io.ciera.tool.sql.ooaofooa.value.impl.ParameterValueSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class OperationParameterSetImpl extends InstanceSet<OperationParameterSet,OperationParameter> implements OperationParameterSet {

    public OperationParameterSetImpl() {
    }

    public OperationParameterSetImpl(Comparator<? super OperationParameter> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setDimensions( String m_Dimensions ) throws XtumlException {
        for ( OperationParameter operationparameter : this ) operationparameter.setDimensions( m_Dimensions );
    }
    @Override
    public void setPrevious_TParm_ID( UniqueId ref_Previous_TParm_ID ) throws XtumlException {
        for ( OperationParameter operationparameter : this ) operationparameter.setPrevious_TParm_ID( ref_Previous_TParm_ID );
    }
    @Override
    public void setTParm_ID( UniqueId m_TParm_ID ) throws XtumlException {
        for ( OperationParameter operationparameter : this ) operationparameter.setTParm_ID( m_TParm_ID );
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( OperationParameter operationparameter : this ) operationparameter.setName( m_Name );
    }
    @Override
    public void setBy_Ref( int m_By_Ref ) throws XtumlException {
        for ( OperationParameter operationparameter : this ) operationparameter.setBy_Ref( m_By_Ref );
    }
    @Override
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        for ( OperationParameter operationparameter : this ) operationparameter.setDT_ID( ref_DT_ID );
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( OperationParameter operationparameter : this ) operationparameter.setDescrip( m_Descrip );
    }
    @Override
    public void setTfr_ID( UniqueId ref_Tfr_ID ) throws XtumlException {
        for ( OperationParameter operationparameter : this ) operationparameter.setTfr_ID( ref_Tfr_ID );
    }


    // selections
    @Override
    public OperationArgumentSet R1015_represents_OperationArgument() throws XtumlException {
        OperationArgumentSet operationargumentset = new OperationArgumentSetImpl();
        for ( OperationParameter operationparameter : this ) operationargumentset.addAll( operationparameter.R1015_represents_OperationArgument() );
        return operationargumentset;
    }
    @Override
    public O_TFRSet R117_is_part_of__O_TFR() throws XtumlException {
        O_TFRSet o_tfrset = new O_TFRSetImpl();
        for ( OperationParameter operationparameter : this ) o_tfrset.add( operationparameter.R117_is_part_of__O_TFR() );
        return o_tfrset;
    }
    @Override
    public DataTypeSet R118_is_defined_by_DataType() throws XtumlException {
        DataTypeSet datatypeset = new DataTypeSetImpl();
        for ( OperationParameter operationparameter : this ) datatypeset.add( operationparameter.R118_is_defined_by_DataType() );
        return datatypeset;
    }
    @Override
    public DimensionsSet R121_may_have_Dimensions() throws XtumlException {
        DimensionsSet dimensionsset = new DimensionsSetImpl();
        for ( OperationParameter operationparameter : this ) dimensionsset.addAll( operationparameter.R121_may_have_Dimensions() );
        return dimensionsset;
    }
    @Override
    public OperationParameterSet R124_precedes_OperationParameter() throws XtumlException {
        OperationParameterSet operationparameterset = new OperationParameterSetImpl();
        for ( OperationParameter operationparameter : this ) operationparameterset.add( operationparameter.R124_precedes_OperationParameter() );
        return operationparameterset;
    }
    @Override
    public OperationParameterSet R124_succeeds_OperationParameter() throws XtumlException {
        OperationParameterSet operationparameterset = new OperationParameterSetImpl();
        for ( OperationParameter operationparameter : this ) operationparameterset.add( operationparameter.R124_succeeds_OperationParameter() );
        return operationparameterset;
    }
    @Override
    public ParameterValueSet R833_ParameterValue() throws XtumlException {
        ParameterValueSet parametervalueset = new ParameterValueSetImpl();
        for ( OperationParameter operationparameter : this ) parametervalueset.addAll( operationparameter.R833_ParameterValue() );
        return parametervalueset;
    }


    @Override
    public OperationParameter nullElement() {
        return OperationParameterImpl.EMPTY_OPERATIONPARAMETER;
    }

    @Override
    public OperationParameterSet emptySet() {
      return new OperationParameterSetImpl();
    }

    @Override
    public OperationParameterSet emptySet(Comparator<? super OperationParameter> comp) {
      return new OperationParameterSetImpl(comp);
    }

    @Override
    public OperationParameterSet value() {
        return this;
    }

    @Override
    public List<OperationParameter> elements() {
        OperationParameter[] elements = toArray(new OperationParameter[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
