package io.ciera.tool.sql.ooaofooa.subsystem.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.subsystem.BaseAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.DerivedBaseAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.NewBaseAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.O_ATTR;
import io.ciera.tool.sql.ooaofooa.subsystem.ReferentialAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.ReferentialAttributeSet;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.DerivedBaseAttributeImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.NewBaseAttributeImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_ATTRImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ReferentialAttributeSetImpl;


public class BaseAttributeImpl extends ModelInstance<BaseAttribute,Sql> implements BaseAttribute {

    public static final String KEY_LETTERS = "O_BATTR";
    public static final BaseAttribute EMPTY_BASEATTRIBUTE = new EmptyBaseAttribute();

    private Sql context;

    // constructors
    private BaseAttributeImpl( Sql context ) {
        this.context = context;
        ref_Attr_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        R106_is_a_O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
        R107_is_a_DerivedBaseAttribute_inst = DerivedBaseAttributeImpl.EMPTY_DERIVEDBASEATTRIBUTE;
        R107_is_a_NewBaseAttribute_inst = NewBaseAttributeImpl.EMPTY_NEWBASEATTRIBUTE;
        R113_can_be_the_base_of_ReferentialAttribute_set = new ReferentialAttributeSetImpl();
    }

    private BaseAttributeImpl( Sql context, UniqueId instanceId, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Attr_ID = ref_Attr_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        R106_is_a_O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
        R107_is_a_DerivedBaseAttribute_inst = DerivedBaseAttributeImpl.EMPTY_DERIVEDBASEATTRIBUTE;
        R107_is_a_NewBaseAttribute_inst = NewBaseAttributeImpl.EMPTY_NEWBASEATTRIBUTE;
        R113_can_be_the_base_of_ReferentialAttribute_set = new ReferentialAttributeSetImpl();
    }

    public static BaseAttribute create( Sql context ) throws XtumlException {
        BaseAttribute newBaseAttribute = new BaseAttributeImpl( context );
        if ( context.addInstance( newBaseAttribute ) ) {
            newBaseAttribute.getRunContext().addChange(new InstanceCreatedDelta(newBaseAttribute, KEY_LETTERS));
            return newBaseAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static BaseAttribute create( Sql context, UniqueId instanceId, UniqueId ref_Attr_ID, UniqueId ref_Obj_ID ) throws XtumlException {
        BaseAttribute newBaseAttribute = new BaseAttributeImpl( context, instanceId, ref_Attr_ID, ref_Obj_ID );
        if ( context.addInstance( newBaseAttribute ) ) {
            return newBaseAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Attr_ID;
    @Override
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Attr_ID.inequality( this.ref_Attr_ID ) ) {
            final UniqueId oldValue = this.ref_Attr_ID;
            this.ref_Attr_ID = ref_Attr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Attr_ID", oldValue, this.ref_Attr_ID));
            if ( !R107_is_a_DerivedBaseAttribute().isEmpty() ) R107_is_a_DerivedBaseAttribute().setAttr_ID( ref_Attr_ID );
            if ( !R107_is_a_NewBaseAttribute().isEmpty() ) R107_is_a_NewBaseAttribute().setAttr_ID( ref_Attr_ID );
            if ( !R113_can_be_the_base_of_ReferentialAttribute().isEmpty() ) R113_can_be_the_base_of_ReferentialAttribute().setBAttr_ID( ref_Attr_ID );
        }
    }
    @Override
    public UniqueId getAttr_ID() throws XtumlException {
        checkLiving();
                return ref_Attr_ID;
    }
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Obj_ID.inequality( this.ref_Obj_ID ) ) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
            if ( !R113_can_be_the_base_of_ReferentialAttribute().isEmpty() ) R113_can_be_the_base_of_ReferentialAttribute().setBObj_ID( ref_Obj_ID );
            if ( !R107_is_a_DerivedBaseAttribute().isEmpty() ) R107_is_a_DerivedBaseAttribute().setObj_ID( ref_Obj_ID );
            if ( !R107_is_a_NewBaseAttribute().isEmpty() ) R107_is_a_NewBaseAttribute().setObj_ID( ref_Obj_ID );
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
                return ref_Obj_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAttr_ID(), getObj_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private O_ATTR R106_is_a_O_ATTR_inst;
    @Override
    public void setR106_is_a_O_ATTR( O_ATTR inst ) {
        R106_is_a_O_ATTR_inst = inst;
    }
    @Override
    public O_ATTR R106_is_a_O_ATTR() throws XtumlException {
        return R106_is_a_O_ATTR_inst;
    }
    private DerivedBaseAttribute R107_is_a_DerivedBaseAttribute_inst;
    @Override
    public void setR107_is_a_DerivedBaseAttribute( DerivedBaseAttribute inst ) {
        R107_is_a_DerivedBaseAttribute_inst = inst;
    }
    @Override
    public DerivedBaseAttribute R107_is_a_DerivedBaseAttribute() throws XtumlException {
        return R107_is_a_DerivedBaseAttribute_inst;
    }
    private NewBaseAttribute R107_is_a_NewBaseAttribute_inst;
    @Override
    public void setR107_is_a_NewBaseAttribute( NewBaseAttribute inst ) {
        R107_is_a_NewBaseAttribute_inst = inst;
    }
    @Override
    public NewBaseAttribute R107_is_a_NewBaseAttribute() throws XtumlException {
        return R107_is_a_NewBaseAttribute_inst;
    }
    private ReferentialAttributeSet R113_can_be_the_base_of_ReferentialAttribute_set;
    @Override
    public void addR113_can_be_the_base_of_ReferentialAttribute( ReferentialAttribute inst ) {
        R113_can_be_the_base_of_ReferentialAttribute_set.add(inst);
    }
    @Override
    public void removeR113_can_be_the_base_of_ReferentialAttribute( ReferentialAttribute inst ) {
        R113_can_be_the_base_of_ReferentialAttribute_set.remove(inst);
    }
    @Override
    public ReferentialAttributeSet R113_can_be_the_base_of_ReferentialAttribute() throws XtumlException {
        return R113_can_be_the_base_of_ReferentialAttribute_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public BaseAttribute value() {
        return this;
    }

    @Override
    public BaseAttribute self() {
        return this;
    }

    @Override
    public BaseAttribute oneWhere( IWhere<BaseAttribute> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_BASEATTRIBUTE;
    }

}

class EmptyBaseAttribute extends ModelInstance<BaseAttribute,Sql> implements BaseAttribute {

    // attributes
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getAttr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public O_ATTR R106_is_a_O_ATTR() {
        return O_ATTRImpl.EMPTY_O_ATTR;
    }
    @Override
    public DerivedBaseAttribute R107_is_a_DerivedBaseAttribute() {
        return DerivedBaseAttributeImpl.EMPTY_DERIVEDBASEATTRIBUTE;
    }
    @Override
    public NewBaseAttribute R107_is_a_NewBaseAttribute() {
        return NewBaseAttributeImpl.EMPTY_NEWBASEATTRIBUTE;
    }
    @Override
    public ReferentialAttributeSet R113_can_be_the_base_of_ReferentialAttribute() {
        return (new ReferentialAttributeSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return BaseAttributeImpl.KEY_LETTERS;
    }

    @Override
    public BaseAttribute value() {
        return this;
    }
    
    @Override
    public BaseAttribute self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public BaseAttribute oneWhere( IWhere<BaseAttribute> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return BaseAttributeImpl.EMPTY_BASEATTRIBUTE;
    }

}
