package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.statemachine.Event;
import io.ciera.tool.sql.architecture.statemachine.impl.EventImpl;
import io.ciera.tool.sql.ooaofooa.event.CreateSMEventStatement;
import io.ciera.tool.sql.ooaofooa.event.CreateSMEventStatementSet;
import io.ciera.tool.sql.ooaofooa.event.GenerateSMEventStatement;
import io.ciera.tool.sql.ooaofooa.event.GenerateSMEventStatementSet;
import io.ciera.tool.sql.ooaofooa.event.impl.CreateSMEventStatementSetImpl;
import io.ciera.tool.sql.ooaofooa.event.impl.GenerateSMEventStatementSetImpl;
import io.ciera.tool.sql.ooaofooa.instance.PendingEvent;
import io.ciera.tool.sql.ooaofooa.instance.PendingEventSet;
import io.ciera.tool.sql.ooaofooa.instance.impl.PendingEventSetImpl;
import io.ciera.tool.sql.ooaofooa.message.EventMessage;
import io.ciera.tool.sql.ooaofooa.message.EventMessageSet;
import io.ciera.tool.sql.ooaofooa.message.impl.EventMessageSetImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.PolymorphicEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.SEMEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.SM_SM;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEventDataItem;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEventDataItemSet;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.PolymorphicEventImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.SEMEventImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.SM_SMImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineEventDataItemSetImpl;


public class StateMachineEventImpl extends ModelInstance<StateMachineEvent,Sql> implements StateMachineEvent {

    public static final String KEY_LETTERS = "SM_EVT";
    public static final StateMachineEvent EMPTY_STATEMACHINEEVENT = new EmptyStateMachineEvent();

    private Sql context;

    // constructors
    private StateMachineEventImpl( Sql context ) {
        this.context = context;
        m_SMevt_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        m_SMspd_IDdeprecated = UniqueId.random();
        m_Numb = 0;
        m_Mning = "";
        m_Is_Lbl_U = 0;
        m_Unq_Lbl = "";
        m_Drv_Lbl = "";
        m_Descrip = "";
        R1009_is_generated_by_EventMessage_set = new EventMessageSetImpl();
        R2906_has_instances_PendingEvent_set = new PendingEventSetImpl();
        R4759_is_basis_for_Event_inst = EventImpl.EMPTY_EVENT;
        R502_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R525_is_a_PolymorphicEvent_inst = PolymorphicEventImpl.EMPTY_POLYMORPHICEVENT;
        R525_is_a_SEMEvent_inst = SEMEventImpl.EMPTY_SEMEVENT;
        R532_carries_StateMachineEventDataItem_set = new StateMachineEventDataItemSetImpl();
        R706_CreateSMEventStatement_set = new CreateSMEventStatementSetImpl();
        R707_GenerateSMEventStatement_set = new GenerateSMEventStatementSetImpl();
    }

    private StateMachineEventImpl( Sql context, UniqueId instanceId, UniqueId m_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated, int m_Numb, String m_Mning, int m_Is_Lbl_U, String m_Unq_Lbl, String m_Drv_Lbl, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.m_SMevt_ID = m_SMevt_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
        this.m_Numb = m_Numb;
        this.m_Mning = m_Mning;
        this.m_Is_Lbl_U = m_Is_Lbl_U;
        this.m_Unq_Lbl = m_Unq_Lbl;
        this.m_Drv_Lbl = m_Drv_Lbl;
        this.m_Descrip = m_Descrip;
        R1009_is_generated_by_EventMessage_set = new EventMessageSetImpl();
        R2906_has_instances_PendingEvent_set = new PendingEventSetImpl();
        R4759_is_basis_for_Event_inst = EventImpl.EMPTY_EVENT;
        R502_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R525_is_a_PolymorphicEvent_inst = PolymorphicEventImpl.EMPTY_POLYMORPHICEVENT;
        R525_is_a_SEMEvent_inst = SEMEventImpl.EMPTY_SEMEVENT;
        R532_carries_StateMachineEventDataItem_set = new StateMachineEventDataItemSetImpl();
        R706_CreateSMEventStatement_set = new CreateSMEventStatementSetImpl();
        R707_GenerateSMEventStatement_set = new GenerateSMEventStatementSetImpl();
    }

    public static StateMachineEvent create( Sql context ) throws XtumlException {
        StateMachineEvent newStateMachineEvent = new StateMachineEventImpl( context );
        if ( context.addInstance( newStateMachineEvent ) ) {
            newStateMachineEvent.getRunContext().addChange(new InstanceCreatedDelta(newStateMachineEvent, KEY_LETTERS));
            return newStateMachineEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static StateMachineEvent create( Sql context, UniqueId instanceId, UniqueId m_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated, int m_Numb, String m_Mning, int m_Is_Lbl_U, String m_Unq_Lbl, String m_Drv_Lbl, String m_Descrip ) throws XtumlException {
        StateMachineEvent newStateMachineEvent = new StateMachineEventImpl( context, instanceId, m_SMevt_ID, ref_SM_ID, m_SMspd_IDdeprecated, m_Numb, m_Mning, m_Is_Lbl_U, m_Unq_Lbl, m_Drv_Lbl, m_Descrip );
        if ( context.addInstance( newStateMachineEvent ) ) {
            return newStateMachineEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_SMevt_ID;
    @Override
    public UniqueId getSMevt_ID() throws XtumlException {
        checkLiving();
                return m_SMevt_ID;
    }
    @Override
    public void setSMevt_ID( UniqueId m_SMevt_ID ) throws XtumlException {
        checkLiving();
        if ( m_SMevt_ID.inequality( this.m_SMevt_ID ) ) {
            final UniqueId oldValue = this.m_SMevt_ID;
            this.m_SMevt_ID = m_SMevt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SMevt_ID", oldValue, this.m_SMevt_ID));
            if ( !R525_is_a_SEMEvent().isEmpty() ) R525_is_a_SEMEvent().setSMevt_ID( m_SMevt_ID );
            if ( !R1009_is_generated_by_EventMessage().isEmpty() ) R1009_is_generated_by_EventMessage().setSMevt_ID( m_SMevt_ID );
            if ( !R2906_has_instances_PendingEvent().isEmpty() ) R2906_has_instances_PendingEvent().setSMevt_ID( m_SMevt_ID );
            if ( !R525_is_a_PolymorphicEvent().isEmpty() ) R525_is_a_PolymorphicEvent().setSMevt_ID( m_SMevt_ID );
            if ( !R532_carries_StateMachineEventDataItem().isEmpty() ) R532_carries_StateMachineEventDataItem().setSMevt_ID( m_SMevt_ID );
            if ( !R4759_is_basis_for_Event().isEmpty() ) R4759_is_basis_for_Event().setSMevt_ID( m_SMevt_ID );
            if ( !R706_CreateSMEventStatement().isEmpty() ) R706_CreateSMEventStatement().setSMevt_ID( m_SMevt_ID );
            if ( !R707_GenerateSMEventStatement().isEmpty() ) R707_GenerateSMEventStatement().setSMevt_ID( m_SMevt_ID );
        }
    }
    private UniqueId ref_SM_ID;
    @Override
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        checkLiving();
        if ( ref_SM_ID.inequality( this.ref_SM_ID ) ) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
            if ( !R525_is_a_SEMEvent().isEmpty() ) R525_is_a_SEMEvent().setSM_ID( ref_SM_ID );
            if ( !R525_is_a_PolymorphicEvent().isEmpty() ) R525_is_a_PolymorphicEvent().setSM_ID( ref_SM_ID );
        }
    }
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
                return ref_SM_ID;
    }
    private UniqueId m_SMspd_IDdeprecated;
    @Override
    public void setSMspd_IDdeprecated( UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        checkLiving();
        if ( m_SMspd_IDdeprecated.inequality( this.m_SMspd_IDdeprecated ) ) {
            final UniqueId oldValue = this.m_SMspd_IDdeprecated;
            this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SMspd_IDdeprecated", oldValue, this.m_SMspd_IDdeprecated));
        }
    }
    @Override
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        checkLiving();
                return m_SMspd_IDdeprecated;
    }
    private int m_Numb;
    @Override
    public void setNumb( int m_Numb ) throws XtumlException {
        checkLiving();
        if ( m_Numb != this.m_Numb ) {
            final int oldValue = this.m_Numb;
            this.m_Numb = m_Numb;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Numb", oldValue, this.m_Numb));
        }
    }
    @Override
    public int getNumb() throws XtumlException {
        checkLiving();
                return m_Numb;
    }
    private String m_Mning;
    @Override
    public void setMning( String m_Mning ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Mning, this.m_Mning ) ) {
            final String oldValue = this.m_Mning;
            this.m_Mning = m_Mning;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Mning", oldValue, this.m_Mning));
        }
    }
    @Override
    public String getMning() throws XtumlException {
        checkLiving();
                return m_Mning;
    }
    private int m_Is_Lbl_U;
    @Override
    public int getIs_Lbl_U() throws XtumlException {
        checkLiving();
                return m_Is_Lbl_U;
    }
    @Override
    public void setIs_Lbl_U( int m_Is_Lbl_U ) throws XtumlException {
        checkLiving();
        if ( m_Is_Lbl_U != this.m_Is_Lbl_U ) {
            final int oldValue = this.m_Is_Lbl_U;
            this.m_Is_Lbl_U = m_Is_Lbl_U;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Is_Lbl_U", oldValue, this.m_Is_Lbl_U));
        }
    }
    private String m_Unq_Lbl;
    @Override
    public void setUnq_Lbl( String m_Unq_Lbl ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Unq_Lbl, this.m_Unq_Lbl ) ) {
            final String oldValue = this.m_Unq_Lbl;
            this.m_Unq_Lbl = m_Unq_Lbl;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Unq_Lbl", oldValue, this.m_Unq_Lbl));
        }
    }
    @Override
    public String getUnq_Lbl() throws XtumlException {
        checkLiving();
                return m_Unq_Lbl;
    }
    private String m_Drv_Lbl;
    @Override
    public void setDrv_Lbl( String m_Drv_Lbl ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Drv_Lbl, this.m_Drv_Lbl ) ) {
            final String oldValue = this.m_Drv_Lbl;
            this.m_Drv_Lbl = m_Drv_Lbl;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Drv_Lbl", oldValue, this.m_Drv_Lbl));
        }
    }
    @Override
    public String getDrv_Lbl() throws XtumlException {
        checkLiving();
                return m_Drv_Lbl;
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
                return m_Descrip;
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Descrip, this.m_Descrip ) ) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSMevt_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }
    @Override
    public IInstanceIdentifier getId2() {
        try {
            return new InstanceIdentifier(getSMevt_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private EventMessageSet R1009_is_generated_by_EventMessage_set;
    @Override
    public void addR1009_is_generated_by_EventMessage( EventMessage inst ) {
        R1009_is_generated_by_EventMessage_set.add(inst);
    }
    @Override
    public void removeR1009_is_generated_by_EventMessage( EventMessage inst ) {
        R1009_is_generated_by_EventMessage_set.remove(inst);
    }
    @Override
    public EventMessageSet R1009_is_generated_by_EventMessage() throws XtumlException {
        return R1009_is_generated_by_EventMessage_set;
    }
    private PendingEventSet R2906_has_instances_PendingEvent_set;
    @Override
    public void addR2906_has_instances_PendingEvent( PendingEvent inst ) {
        R2906_has_instances_PendingEvent_set.add(inst);
    }
    @Override
    public void removeR2906_has_instances_PendingEvent( PendingEvent inst ) {
        R2906_has_instances_PendingEvent_set.remove(inst);
    }
    @Override
    public PendingEventSet R2906_has_instances_PendingEvent() throws XtumlException {
        return R2906_has_instances_PendingEvent_set;
    }
    private Event R4759_is_basis_for_Event_inst;
    @Override
    public void setR4759_is_basis_for_Event( Event inst ) {
        R4759_is_basis_for_Event_inst = inst;
    }
    @Override
    public Event R4759_is_basis_for_Event() throws XtumlException {
        return R4759_is_basis_for_Event_inst;
    }
    private SM_SM R502_SM_SM_inst;
    @Override
    public void setR502_SM_SM( SM_SM inst ) {
        R502_SM_SM_inst = inst;
    }
    @Override
    public SM_SM R502_SM_SM() throws XtumlException {
        return R502_SM_SM_inst;
    }
    private PolymorphicEvent R525_is_a_PolymorphicEvent_inst;
    @Override
    public void setR525_is_a_PolymorphicEvent( PolymorphicEvent inst ) {
        R525_is_a_PolymorphicEvent_inst = inst;
    }
    @Override
    public PolymorphicEvent R525_is_a_PolymorphicEvent() throws XtumlException {
        return R525_is_a_PolymorphicEvent_inst;
    }
    private SEMEvent R525_is_a_SEMEvent_inst;
    @Override
    public void setR525_is_a_SEMEvent( SEMEvent inst ) {
        R525_is_a_SEMEvent_inst = inst;
    }
    @Override
    public SEMEvent R525_is_a_SEMEvent() throws XtumlException {
        return R525_is_a_SEMEvent_inst;
    }
    private StateMachineEventDataItemSet R532_carries_StateMachineEventDataItem_set;
    @Override
    public void addR532_carries_StateMachineEventDataItem( StateMachineEventDataItem inst ) {
        R532_carries_StateMachineEventDataItem_set.add(inst);
    }
    @Override
    public void removeR532_carries_StateMachineEventDataItem( StateMachineEventDataItem inst ) {
        R532_carries_StateMachineEventDataItem_set.remove(inst);
    }
    @Override
    public StateMachineEventDataItemSet R532_carries_StateMachineEventDataItem() throws XtumlException {
        return R532_carries_StateMachineEventDataItem_set;
    }
    private CreateSMEventStatementSet R706_CreateSMEventStatement_set;
    @Override
    public void addR706_CreateSMEventStatement( CreateSMEventStatement inst ) {
        R706_CreateSMEventStatement_set.add(inst);
    }
    @Override
    public void removeR706_CreateSMEventStatement( CreateSMEventStatement inst ) {
        R706_CreateSMEventStatement_set.remove(inst);
    }
    @Override
    public CreateSMEventStatementSet R706_CreateSMEventStatement() throws XtumlException {
        return R706_CreateSMEventStatement_set;
    }
    private GenerateSMEventStatementSet R707_GenerateSMEventStatement_set;
    @Override
    public void addR707_GenerateSMEventStatement( GenerateSMEventStatement inst ) {
        R707_GenerateSMEventStatement_set.add(inst);
    }
    @Override
    public void removeR707_GenerateSMEventStatement( GenerateSMEventStatement inst ) {
        R707_GenerateSMEventStatement_set.remove(inst);
    }
    @Override
    public GenerateSMEventStatementSet R707_GenerateSMEventStatement() throws XtumlException {
        return R707_GenerateSMEventStatement_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public StateMachineEvent value() {
        return this;
    }

    @Override
    public StateMachineEvent self() {
        return this;
    }

    @Override
    public StateMachineEvent oneWhere( IWhere<StateMachineEvent> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_STATEMACHINEEVENT;
    }

}

class EmptyStateMachineEvent extends ModelInstance<StateMachineEvent,Sql> implements StateMachineEvent {

    // attributes
    public UniqueId getSMevt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMevt_ID( UniqueId m_SMevt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMspd_IDdeprecated( UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setNumb( int m_Numb ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getNumb() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setMning( String m_Mning ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getMning() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getIs_Lbl_U() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIs_Lbl_U( int m_Is_Lbl_U ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setUnq_Lbl( String m_Unq_Lbl ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getUnq_Lbl() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDrv_Lbl( String m_Drv_Lbl ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDrv_Lbl() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public EventMessageSet R1009_is_generated_by_EventMessage() {
        return (new EventMessageSetImpl());
    }
    @Override
    public PendingEventSet R2906_has_instances_PendingEvent() {
        return (new PendingEventSetImpl());
    }
    @Override
    public Event R4759_is_basis_for_Event() {
        return EventImpl.EMPTY_EVENT;
    }
    @Override
    public SM_SM R502_SM_SM() {
        return SM_SMImpl.EMPTY_SM_SM;
    }
    @Override
    public PolymorphicEvent R525_is_a_PolymorphicEvent() {
        return PolymorphicEventImpl.EMPTY_POLYMORPHICEVENT;
    }
    @Override
    public SEMEvent R525_is_a_SEMEvent() {
        return SEMEventImpl.EMPTY_SEMEVENT;
    }
    @Override
    public StateMachineEventDataItemSet R532_carries_StateMachineEventDataItem() {
        return (new StateMachineEventDataItemSetImpl());
    }
    @Override
    public CreateSMEventStatementSet R706_CreateSMEventStatement() {
        return (new CreateSMEventStatementSetImpl());
    }
    @Override
    public GenerateSMEventStatementSet R707_GenerateSMEventStatement() {
        return (new GenerateSMEventStatementSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return StateMachineEventImpl.KEY_LETTERS;
    }

    @Override
    public StateMachineEvent value() {
        return this;
    }
    
    @Override
    public StateMachineEvent self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public StateMachineEvent oneWhere( IWhere<StateMachineEvent> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
    }

}
