package io.ciera.tool.sql.ooaofooa.packageableelement.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.elementpackaging.EP_PKG;
import io.ciera.tool.sql.ooaofooa.elementpackaging.impl.EP_PKGImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.ElementVisibility;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.SearchResultSet;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.SearchResultSetImpl;

import ooaofooa.datatypes.ElementTypeConstants;


public class ElementVisibilityImpl extends ModelInstance<ElementVisibility,Sql> implements ElementVisibility {

    public static final String KEY_LETTERS = "PE_VIS";
    public static final ElementVisibility EMPTY_ELEMENTVISIBILITY = new EmptyElementVisibility();

    private Sql context;

    // constructors
    private ElementVisibilityImpl( Sql context ) {
        this.context = context;
        m_Visibility_ID = UniqueId.random();
        ref_Element_ID = UniqueId.random();
        ref_Package_ID = UniqueId.random();
        ref_Name = "";
        ref_Type = ElementTypeConstants.UNINITIALIZED_ENUM;
        R8002_has_visibility_of_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R8002_is_visible_to_elements_in_EP_PKG_inst = EP_PKGImpl.EMPTY_EP_PKG;
        R8006_SearchResultSet_inst = SearchResultSetImpl.EMPTY_SEARCHRESULTSET;
    }

    private ElementVisibilityImpl( Sql context, UniqueId instanceId, UniqueId m_Visibility_ID, UniqueId ref_Element_ID, UniqueId ref_Package_ID, String ref_Name, ElementTypeConstants ref_Type ) {
        super(instanceId);
        this.context = context;
        this.m_Visibility_ID = m_Visibility_ID;
        this.ref_Element_ID = ref_Element_ID;
        this.ref_Package_ID = ref_Package_ID;
        this.ref_Name = ref_Name;
        this.ref_Type = ref_Type;
        R8002_has_visibility_of_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R8002_is_visible_to_elements_in_EP_PKG_inst = EP_PKGImpl.EMPTY_EP_PKG;
        R8006_SearchResultSet_inst = SearchResultSetImpl.EMPTY_SEARCHRESULTSET;
    }

    public static ElementVisibility create( Sql context ) throws XtumlException {
        ElementVisibility newElementVisibility = new ElementVisibilityImpl( context );
        if ( context.addInstance( newElementVisibility ) ) {
            newElementVisibility.getRunContext().addChange(new InstanceCreatedDelta(newElementVisibility, KEY_LETTERS));
            return newElementVisibility;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ElementVisibility create( Sql context, UniqueId instanceId, UniqueId m_Visibility_ID, UniqueId ref_Element_ID, UniqueId ref_Package_ID, String ref_Name, ElementTypeConstants ref_Type ) throws XtumlException {
        ElementVisibility newElementVisibility = new ElementVisibilityImpl( context, instanceId, m_Visibility_ID, ref_Element_ID, ref_Package_ID, ref_Name, ref_Type );
        if ( context.addInstance( newElementVisibility ) ) {
            return newElementVisibility;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Visibility_ID;
    @Override
    public void setVisibility_ID( UniqueId m_Visibility_ID ) throws XtumlException {
        checkLiving();
        if ( m_Visibility_ID.inequality( this.m_Visibility_ID ) ) {
            final UniqueId oldValue = this.m_Visibility_ID;
            this.m_Visibility_ID = m_Visibility_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Visibility_ID", oldValue, this.m_Visibility_ID));
        }
    }
    @Override
    public UniqueId getVisibility_ID() throws XtumlException {
        checkLiving();
                return m_Visibility_ID;
    }
    private UniqueId ref_Element_ID;
    @Override
    public UniqueId getElement_ID() throws XtumlException {
        checkLiving();
                return ref_Element_ID;
    }
    @Override
    public void setElement_ID( UniqueId ref_Element_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Element_ID.inequality( this.ref_Element_ID ) ) {
            final UniqueId oldValue = this.ref_Element_ID;
            this.ref_Element_ID = ref_Element_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Element_ID", oldValue, this.ref_Element_ID));
        }
    }
    private UniqueId ref_Package_ID;
    @Override
    public UniqueId getPackage_ID() throws XtumlException {
        checkLiving();
                return ref_Package_ID;
    }
    @Override
    public void setPackage_ID( UniqueId ref_Package_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Package_ID.inequality( this.ref_Package_ID ) ) {
            final UniqueId oldValue = this.ref_Package_ID;
            this.ref_Package_ID = ref_Package_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Package_ID", oldValue, this.ref_Package_ID));
        }
    }
    private String ref_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return ref_Name;
    }
    @Override
    public void setName( String ref_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_Name, this.ref_Name ) ) {
            final String oldValue = this.ref_Name;
            this.ref_Name = ref_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Name", oldValue, this.ref_Name));
        }
    }
    private ElementTypeConstants ref_Type;
    @Override
    public void setType( ElementTypeConstants ref_Type ) throws XtumlException {
        checkLiving();
        if ( ref_Type.inequality( this.ref_Type ) ) {
            final ElementTypeConstants oldValue = this.ref_Type;
            this.ref_Type = ref_Type;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Type", oldValue, this.ref_Type));
        }
    }
    @Override
    public ElementTypeConstants getType() throws XtumlException {
        checkLiving();
                return ref_Type;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getVisibility_ID(), getElement_ID(), getPackage_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private PackageableElement R8002_has_visibility_of_PackageableElement_inst;
    @Override
    public void setR8002_has_visibility_of_PackageableElement( PackageableElement inst ) {
        R8002_has_visibility_of_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8002_has_visibility_of_PackageableElement() throws XtumlException {
        return R8002_has_visibility_of_PackageableElement_inst;
    }
    private EP_PKG R8002_is_visible_to_elements_in_EP_PKG_inst;
    @Override
    public void setR8002_is_visible_to_elements_in_EP_PKG( EP_PKG inst ) {
        R8002_is_visible_to_elements_in_EP_PKG_inst = inst;
    }
    @Override
    public EP_PKG R8002_is_visible_to_elements_in_EP_PKG() throws XtumlException {
        return R8002_is_visible_to_elements_in_EP_PKG_inst;
    }
    private SearchResultSet R8006_SearchResultSet_inst;
    @Override
    public void setR8006_SearchResultSet( SearchResultSet inst ) {
        R8006_SearchResultSet_inst = inst;
    }
    @Override
    public SearchResultSet R8006_SearchResultSet() throws XtumlException {
        return R8006_SearchResultSet_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ElementVisibility value() {
        return this;
    }

    @Override
    public ElementVisibility self() {
        return this;
    }

    @Override
    public ElementVisibility oneWhere( IWhere<ElementVisibility> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_ELEMENTVISIBILITY;
    }

}

class EmptyElementVisibility extends ModelInstance<ElementVisibility,Sql> implements ElementVisibility {

    // attributes
    public void setVisibility_ID( UniqueId m_Visibility_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getVisibility_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getElement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setElement_ID( UniqueId ref_Element_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPackage_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage_ID( UniqueId ref_Package_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String ref_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setType( ElementTypeConstants ref_Type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ElementTypeConstants getType() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public PackageableElement R8002_has_visibility_of_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }
    @Override
    public EP_PKG R8002_is_visible_to_elements_in_EP_PKG() {
        return EP_PKGImpl.EMPTY_EP_PKG;
    }
    @Override
    public SearchResultSet R8006_SearchResultSet() {
        return SearchResultSetImpl.EMPTY_SEARCHRESULTSET;
    }


    @Override
    public String getKeyLetters() {
        return ElementVisibilityImpl.KEY_LETTERS;
    }

    @Override
    public ElementVisibility value() {
        return this;
    }
    
    @Override
    public ElementVisibility self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ElementVisibility oneWhere( IWhere<ElementVisibility> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return ElementVisibilityImpl.EMPTY_ELEMENTVISIBILITY;
    }

}
