package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.S_SYNC;
import io.ciera.tool.sql.ooaofooa.domain.impl.S_SYNCImpl;
import io.ciera.tool.sql.ooaofooa.message.FunctionMessage;
import io.ciera.tool.sql.ooaofooa.message.SynchronousMessage;
import io.ciera.tool.sql.ooaofooa.message.impl.SynchronousMessageImpl;


public class FunctionMessageImpl extends ModelInstance<FunctionMessage,Sql> implements FunctionMessage {

    public static final String KEY_LETTERS = "MSG_F";
    public static final FunctionMessage EMPTY_FUNCTIONMESSAGE = new EmptyFunctionMessage();

    private Sql context;

    // constructors
    private FunctionMessageImpl( Sql context ) {
        this.context = context;
        ref_Msg_ID = UniqueId.random();
        ref_Sync_ID = UniqueId.random();
        R1010_is_invocation_of_S_SYNC_inst = S_SYNCImpl.EMPTY_S_SYNC;
        R1020_is_a_SynchronousMessage_inst = SynchronousMessageImpl.EMPTY_SYNCHRONOUSMESSAGE;
    }

    private FunctionMessageImpl( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, UniqueId ref_Sync_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Msg_ID = ref_Msg_ID;
        this.ref_Sync_ID = ref_Sync_ID;
        R1010_is_invocation_of_S_SYNC_inst = S_SYNCImpl.EMPTY_S_SYNC;
        R1020_is_a_SynchronousMessage_inst = SynchronousMessageImpl.EMPTY_SYNCHRONOUSMESSAGE;
    }

    public static FunctionMessage create( Sql context ) throws XtumlException {
        FunctionMessage newFunctionMessage = new FunctionMessageImpl( context );
        if ( context.addInstance( newFunctionMessage ) ) {
            newFunctionMessage.getRunContext().addChange(new InstanceCreatedDelta(newFunctionMessage, KEY_LETTERS));
            return newFunctionMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static FunctionMessage create( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, UniqueId ref_Sync_ID ) throws XtumlException {
        FunctionMessage newFunctionMessage = new FunctionMessageImpl( context, instanceId, ref_Msg_ID, ref_Sync_ID );
        if ( context.addInstance( newFunctionMessage ) ) {
            return newFunctionMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Msg_ID;
    @Override
    public void setMsg_ID( UniqueId ref_Msg_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Msg_ID.inequality( this.ref_Msg_ID ) ) {
            final UniqueId oldValue = this.ref_Msg_ID;
            this.ref_Msg_ID = ref_Msg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Msg_ID", oldValue, this.ref_Msg_ID));
        }
    }
    @Override
    public UniqueId getMsg_ID() throws XtumlException {
        checkLiving();
                return ref_Msg_ID;
    }
    private UniqueId ref_Sync_ID;
    @Override
    public void setSync_ID( UniqueId ref_Sync_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Sync_ID.inequality( this.ref_Sync_ID ) ) {
            final UniqueId oldValue = this.ref_Sync_ID;
            this.ref_Sync_ID = ref_Sync_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Sync_ID", oldValue, this.ref_Sync_ID));
        }
    }
    @Override
    public UniqueId getSync_ID() throws XtumlException {
        checkLiving();
                return ref_Sync_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getMsg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private S_SYNC R1010_is_invocation_of_S_SYNC_inst;
    @Override
    public void setR1010_is_invocation_of_S_SYNC( S_SYNC inst ) {
        R1010_is_invocation_of_S_SYNC_inst = inst;
    }
    @Override
    public S_SYNC R1010_is_invocation_of_S_SYNC() throws XtumlException {
        return R1010_is_invocation_of_S_SYNC_inst;
    }
    private SynchronousMessage R1020_is_a_SynchronousMessage_inst;
    @Override
    public void setR1020_is_a_SynchronousMessage( SynchronousMessage inst ) {
        R1020_is_a_SynchronousMessage_inst = inst;
    }
    @Override
    public SynchronousMessage R1020_is_a_SynchronousMessage() throws XtumlException {
        return R1020_is_a_SynchronousMessage_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public FunctionMessage value() {
        return this;
    }

    @Override
    public FunctionMessage self() {
        return this;
    }

    @Override
    public FunctionMessage oneWhere( IWhere<FunctionMessage> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_FUNCTIONMESSAGE;
    }

}

class EmptyFunctionMessage extends ModelInstance<FunctionMessage,Sql> implements FunctionMessage {

    // attributes
    public void setMsg_ID( UniqueId ref_Msg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getMsg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSync_ID( UniqueId ref_Sync_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSync_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public S_SYNC R1010_is_invocation_of_S_SYNC() {
        return S_SYNCImpl.EMPTY_S_SYNC;
    }
    @Override
    public SynchronousMessage R1020_is_a_SynchronousMessage() {
        return SynchronousMessageImpl.EMPTY_SYNCHRONOUSMESSAGE;
    }


    @Override
    public String getKeyLetters() {
        return FunctionMessageImpl.KEY_LETTERS;
    }

    @Override
    public FunctionMessage value() {
        return this;
    }
    
    @Override
    public FunctionMessage self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public FunctionMessage oneWhere( IWhere<FunctionMessage> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return FunctionMessageImpl.EMPTY_FUNCTIONMESSAGE;
    }

}
