package io.ciera.tool.sql.ooaofooa.interaction.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.interaction.TimeSpan;
import io.ciera.tool.sql.ooaofooa.interaction.TimingMark;
import io.ciera.tool.sql.ooaofooa.interaction.impl.TimingMarkImpl;


public class TimeSpanImpl extends ModelInstance<TimeSpan,Sql> implements TimeSpan {

    public static final String KEY_LETTERS = "SQ_TS";
    public static final TimeSpan EMPTY_TIMESPAN = new EmptyTimeSpan();

    private Sql context;

    // constructors
    private TimeSpanImpl( Sql context ) {
        this.context = context;
        m_Span_ID = UniqueId.random();
        ref_Mark_ID = UniqueId.random();
        ref_Prev_Mark_ID = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        R941_span_begins_at_TimingMark_inst = TimingMarkImpl.EMPTY_TIMINGMARK;
        R942_span_ends_at_TimingMark_inst = TimingMarkImpl.EMPTY_TIMINGMARK;
    }

    private TimeSpanImpl( Sql context, UniqueId instanceId, UniqueId m_Span_ID, UniqueId ref_Mark_ID, UniqueId ref_Prev_Mark_ID, String m_Name, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.m_Span_ID = m_Span_ID;
        this.ref_Mark_ID = ref_Mark_ID;
        this.ref_Prev_Mark_ID = ref_Prev_Mark_ID;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        R941_span_begins_at_TimingMark_inst = TimingMarkImpl.EMPTY_TIMINGMARK;
        R942_span_ends_at_TimingMark_inst = TimingMarkImpl.EMPTY_TIMINGMARK;
    }

    public static TimeSpan create( Sql context ) throws XtumlException {
        TimeSpan newTimeSpan = new TimeSpanImpl( context );
        if ( context.addInstance( newTimeSpan ) ) {
            newTimeSpan.getRunContext().addChange(new InstanceCreatedDelta(newTimeSpan, KEY_LETTERS));
            return newTimeSpan;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static TimeSpan create( Sql context, UniqueId instanceId, UniqueId m_Span_ID, UniqueId ref_Mark_ID, UniqueId ref_Prev_Mark_ID, String m_Name, String m_Descrip ) throws XtumlException {
        TimeSpan newTimeSpan = new TimeSpanImpl( context, instanceId, m_Span_ID, ref_Mark_ID, ref_Prev_Mark_ID, m_Name, m_Descrip );
        if ( context.addInstance( newTimeSpan ) ) {
            return newTimeSpan;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Span_ID;
    @Override
    public void setSpan_ID( UniqueId m_Span_ID ) throws XtumlException {
        checkLiving();
        if ( m_Span_ID.inequality( this.m_Span_ID ) ) {
            final UniqueId oldValue = this.m_Span_ID;
            this.m_Span_ID = m_Span_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Span_ID", oldValue, this.m_Span_ID));
        }
    }
    @Override
    public UniqueId getSpan_ID() throws XtumlException {
        checkLiving();
                return m_Span_ID;
    }
    private UniqueId ref_Mark_ID;
    @Override
    public void setMark_ID( UniqueId ref_Mark_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Mark_ID.inequality( this.ref_Mark_ID ) ) {
            final UniqueId oldValue = this.ref_Mark_ID;
            this.ref_Mark_ID = ref_Mark_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Mark_ID", oldValue, this.ref_Mark_ID));
        }
    }
    @Override
    public UniqueId getMark_ID() throws XtumlException {
        checkLiving();
                return ref_Mark_ID;
    }
    private UniqueId ref_Prev_Mark_ID;
    @Override
    public UniqueId getPrev_Mark_ID() throws XtumlException {
        checkLiving();
                return ref_Prev_Mark_ID;
    }
    @Override
    public void setPrev_Mark_ID( UniqueId ref_Prev_Mark_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Prev_Mark_ID.inequality( this.ref_Prev_Mark_ID ) ) {
            final UniqueId oldValue = this.ref_Prev_Mark_ID;
            this.ref_Prev_Mark_ID = ref_Prev_Mark_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Prev_Mark_ID", oldValue, this.ref_Prev_Mark_ID));
        }
    }
    private String m_Name;
    @Override
    public void setName( String m_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Name, this.m_Name ) ) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return m_Name;
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
                return m_Descrip;
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Descrip, this.m_Descrip ) ) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSpan_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private TimingMark R941_span_begins_at_TimingMark_inst;
    @Override
    public void setR941_span_begins_at_TimingMark( TimingMark inst ) {
        R941_span_begins_at_TimingMark_inst = inst;
    }
    @Override
    public TimingMark R941_span_begins_at_TimingMark() throws XtumlException {
        return R941_span_begins_at_TimingMark_inst;
    }
    private TimingMark R942_span_ends_at_TimingMark_inst;
    @Override
    public void setR942_span_ends_at_TimingMark( TimingMark inst ) {
        R942_span_ends_at_TimingMark_inst = inst;
    }
    @Override
    public TimingMark R942_span_ends_at_TimingMark() throws XtumlException {
        return R942_span_ends_at_TimingMark_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public TimeSpan value() {
        return this;
    }

    @Override
    public TimeSpan self() {
        return this;
    }

    @Override
    public TimeSpan oneWhere( IWhere<TimeSpan> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_TIMESPAN;
    }

}

class EmptyTimeSpan extends ModelInstance<TimeSpan,Sql> implements TimeSpan {

    // attributes
    public void setSpan_ID( UniqueId m_Span_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSpan_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setMark_ID( UniqueId ref_Mark_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getMark_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getPrev_Mark_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPrev_Mark_ID( UniqueId ref_Prev_Mark_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public TimingMark R941_span_begins_at_TimingMark() {
        return TimingMarkImpl.EMPTY_TIMINGMARK;
    }
    @Override
    public TimingMark R942_span_ends_at_TimingMark() {
        return TimingMarkImpl.EMPTY_TIMINGMARK;
    }


    @Override
    public String getKeyLetters() {
        return TimeSpanImpl.KEY_LETTERS;
    }

    @Override
    public TimeSpan value() {
        return this;
    }
    
    @Override
    public TimeSpan self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public TimeSpan oneWhere( IWhere<TimeSpan> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return TimeSpanImpl.EMPTY_TIMESPAN;
    }

}
