package io.ciera.tool.sql.ooaofooa.instanceaccess.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.instanceaccess.Create;
import io.ciera.tool.sql.ooaofooa.subsystem.ModelClass;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ModelClassImpl;
import io.ciera.tool.sql.ooaofooa.value.V_VAR;
import io.ciera.tool.sql.ooaofooa.value.impl.V_VARImpl;


public class CreateImpl extends ModelInstance<Create,Sql> implements Create {

    public static final String KEY_LETTERS = "ACT_CR";
    public static final Create EMPTY_CREATE = new EmptyCreate();

    private Sql context;

    // constructors
    private CreateImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_Var_ID = UniqueId.random();
        m_is_implicit = false;
        ref_Obj_ID = UniqueId.random();
        m_modelClassKeyLettersLineNumber = 0;
        m_modelClassKeyLettersColumn = 0;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R633_result_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R671_instance_of_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
    }

    private CreateImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Var_ID, boolean m_is_implicit, UniqueId ref_Obj_ID, int m_modelClassKeyLettersLineNumber, int m_modelClassKeyLettersColumn ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Var_ID = ref_Var_ID;
        this.m_is_implicit = m_is_implicit;
        this.ref_Obj_ID = ref_Obj_ID;
        this.m_modelClassKeyLettersLineNumber = m_modelClassKeyLettersLineNumber;
        this.m_modelClassKeyLettersColumn = m_modelClassKeyLettersColumn;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R633_result_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R671_instance_of_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
    }

    public static Create create( Sql context ) throws XtumlException {
        Create newCreate = new CreateImpl( context );
        if ( context.addInstance( newCreate ) ) {
            newCreate.getRunContext().addChange(new InstanceCreatedDelta(newCreate, KEY_LETTERS));
            return newCreate;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Create create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Var_ID, boolean m_is_implicit, UniqueId ref_Obj_ID, int m_modelClassKeyLettersLineNumber, int m_modelClassKeyLettersColumn ) throws XtumlException {
        Create newCreate = new CreateImpl( context, instanceId, ref_Statement_ID, ref_Var_ID, m_is_implicit, ref_Obj_ID, m_modelClassKeyLettersLineNumber, m_modelClassKeyLettersColumn );
        if ( context.addInstance( newCreate ) ) {
            return newCreate;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
                return ref_Statement_ID;
    }
    @Override
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Statement_ID.inequality( this.ref_Statement_ID ) ) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
        }
    }
    private UniqueId ref_Var_ID;
    @Override
    public void setVar_ID( UniqueId ref_Var_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Var_ID.inequality( this.ref_Var_ID ) ) {
            final UniqueId oldValue = this.ref_Var_ID;
            this.ref_Var_ID = ref_Var_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Var_ID", oldValue, this.ref_Var_ID));
        }
    }
    @Override
    public UniqueId getVar_ID() throws XtumlException {
        checkLiving();
                return ref_Var_ID;
    }
    private boolean m_is_implicit;
    @Override
    public boolean getIs_implicit() throws XtumlException {
        checkLiving();
                return m_is_implicit;
    }
    @Override
    public void setIs_implicit( boolean m_is_implicit ) throws XtumlException {
        checkLiving();
        if ( m_is_implicit != this.m_is_implicit ) {
            final boolean oldValue = this.m_is_implicit;
            this.m_is_implicit = m_is_implicit;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_is_implicit", oldValue, this.m_is_implicit));
        }
    }
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Obj_ID.inequality( this.ref_Obj_ID ) ) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
                return ref_Obj_ID;
    }
    private int m_modelClassKeyLettersLineNumber;
    @Override
    public void setModelClassKeyLettersLineNumber( int m_modelClassKeyLettersLineNumber ) throws XtumlException {
        checkLiving();
        if ( m_modelClassKeyLettersLineNumber != this.m_modelClassKeyLettersLineNumber ) {
            final int oldValue = this.m_modelClassKeyLettersLineNumber;
            this.m_modelClassKeyLettersLineNumber = m_modelClassKeyLettersLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_modelClassKeyLettersLineNumber", oldValue, this.m_modelClassKeyLettersLineNumber));
        }
    }
    @Override
    public int getModelClassKeyLettersLineNumber() throws XtumlException {
        checkLiving();
                return m_modelClassKeyLettersLineNumber;
    }
    private int m_modelClassKeyLettersColumn;
    @Override
    public int getModelClassKeyLettersColumn() throws XtumlException {
        checkLiving();
                return m_modelClassKeyLettersColumn;
    }
    @Override
    public void setModelClassKeyLettersColumn( int m_modelClassKeyLettersColumn ) throws XtumlException {
        checkLiving();
        if ( m_modelClassKeyLettersColumn != this.m_modelClassKeyLettersColumn ) {
            final int oldValue = this.m_modelClassKeyLettersColumn;
            this.m_modelClassKeyLettersColumn = m_modelClassKeyLettersColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_modelClassKeyLettersColumn", oldValue, this.m_modelClassKeyLettersColumn));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SMT R603_is_a_ACT_SMT_inst;
    @Override
    public void setR603_is_a_ACT_SMT( ACT_SMT inst ) {
        R603_is_a_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() throws XtumlException {
        return R603_is_a_ACT_SMT_inst;
    }
    private V_VAR R633_result_V_VAR_inst;
    @Override
    public void setR633_result_V_VAR( V_VAR inst ) {
        R633_result_V_VAR_inst = inst;
    }
    @Override
    public V_VAR R633_result_V_VAR() throws XtumlException {
        return R633_result_V_VAR_inst;
    }
    private ModelClass R671_instance_of_ModelClass_inst;
    @Override
    public void setR671_instance_of_ModelClass( ModelClass inst ) {
        R671_instance_of_ModelClass_inst = inst;
    }
    @Override
    public ModelClass R671_instance_of_ModelClass() throws XtumlException {
        return R671_instance_of_ModelClass_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Create value() {
        return this;
    }

    @Override
    public Create self() {
        return this;
    }

    @Override
    public Create oneWhere( IWhere<Create> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_CREATE;
    }

}

class EmptyCreate extends ModelInstance<Create,Sql> implements Create {

    // attributes
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setVar_ID( UniqueId ref_Var_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getVar_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public boolean getIs_implicit() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIs_implicit( boolean m_is_implicit ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setModelClassKeyLettersLineNumber( int m_modelClassKeyLettersLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getModelClassKeyLettersLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getModelClassKeyLettersColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setModelClassKeyLettersColumn( int m_modelClassKeyLettersColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }
    @Override
    public V_VAR R633_result_V_VAR() {
        return V_VARImpl.EMPTY_V_VAR;
    }
    @Override
    public ModelClass R671_instance_of_ModelClass() {
        return ModelClassImpl.EMPTY_MODELCLASS;
    }


    @Override
    public String getKeyLetters() {
        return CreateImpl.KEY_LETTERS;
    }

    @Override
    public Create value() {
        return this;
    }
    
    @Override
    public Create self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Create oneWhere( IWhere<Create> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return CreateImpl.EMPTY_CREATE;
    }

}
