package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.domain.Range;
import io.ciera.tool.sql.ooaofooa.domain.RangeSet;
import io.ciera.tool.sql.ooaofooa.domain.UserDataTypeSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.UserDataTypeSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class RangeSetImpl extends InstanceSet<RangeSet,Range> implements RangeSet {

    public RangeSetImpl() {
    }

    public RangeSetImpl(Comparator<? super Range> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        for ( Range range : this ) range.setDT_ID( ref_DT_ID );
    }
    @Override
    public void setMax( String m_Max ) throws XtumlException {
        for ( Range range : this ) range.setMax( m_Max );
    }
    @Override
    public void setMin( String m_Min ) throws XtumlException {
        for ( Range range : this ) range.setMin( m_Min );
    }


    // selections
    @Override
    public UserDataTypeSet R57_spans_UserDataType() throws XtumlException {
        UserDataTypeSet userdatatypeset = new UserDataTypeSetImpl();
        for ( Range range : this ) userdatatypeset.add( range.R57_spans_UserDataType() );
        return userdatatypeset;
    }


    @Override
    public Range nullElement() {
        return RangeImpl.EMPTY_RANGE;
    }

    @Override
    public RangeSet emptySet() {
      return new RangeSetImpl();
    }

    @Override
    public RangeSet emptySet(Comparator<? super Range> comp) {
      return new RangeSetImpl(comp);
    }

    @Override
    public RangeSet value() {
        return this;
    }

    @Override
    public List<Range> elements() {
        return Arrays.asList(toArray(new Range[0]));
    }

}
