package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.Exception;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;


public class ExceptionImpl extends ModelInstance<Exception,Sql> implements Exception {

    public static final String KEY_LETTERS = "S_EXP";
    public static final Exception EMPTY_EXCEPTION = new EmptyException();

    private Sql context;

    // constructors
    private ExceptionImpl( Sql context ) {
        this.context = context;
        ref_Exception_ID = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    private ExceptionImpl( Sql context, UniqueId instanceId, UniqueId ref_Exception_ID, String m_Name, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.ref_Exception_ID = ref_Exception_ID;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    public static Exception create( Sql context ) throws XtumlException {
        Exception newException = new ExceptionImpl( context );
        if ( context.addInstance( newException ) ) {
            newException.getRunContext().addChange(new InstanceCreatedDelta(newException, KEY_LETTERS));
            return newException;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Exception create( Sql context, UniqueId instanceId, UniqueId ref_Exception_ID, String m_Name, String m_Descrip ) throws XtumlException {
        Exception newException = new ExceptionImpl( context, instanceId, ref_Exception_ID, m_Name, m_Descrip );
        if ( context.addInstance( newException ) ) {
            return newException;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Exception_ID;
    @Override
    public UniqueId getException_ID() throws XtumlException {
        checkLiving();
                return ref_Exception_ID;
    }
    @Override
    public void setException_ID( UniqueId ref_Exception_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Exception_ID.inequality( this.ref_Exception_ID ) ) {
            final UniqueId oldValue = this.ref_Exception_ID;
            this.ref_Exception_ID = ref_Exception_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Exception_ID", oldValue, this.ref_Exception_ID));
        }
    }
    private String m_Name;
    @Override
    public void setName( String m_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Name, this.m_Name ) ) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return m_Name;
    }
    private String m_Descrip;
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Descrip, this.m_Descrip ) ) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
                return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getException_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private PackageableElement R8001_is_a_PackageableElement_inst;
    @Override
    public void setR8001_is_a_PackageableElement( PackageableElement inst ) {
        R8001_is_a_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() throws XtumlException {
        return R8001_is_a_PackageableElement_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Exception value() {
        return this;
    }

    @Override
    public Exception self() {
        return this;
    }

    @Override
    public Exception oneWhere( IWhere<Exception> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_EXCEPTION;
    }

}

class EmptyException extends ModelInstance<Exception,Sql> implements Exception {

    // attributes
    public UniqueId getException_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setException_ID( UniqueId ref_Exception_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public PackageableElement R8001_is_a_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }


    @Override
    public String getKeyLetters() {
        return ExceptionImpl.KEY_LETTERS;
    }

    @Override
    public Exception value() {
        return this;
    }
    
    @Override
    public Exception self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Exception oneWhere( IWhere<Exception> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return ExceptionImpl.EMPTY_EXCEPTION;
    }

}
