package io.ciera.tool.sql.ooaofooa.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.Delegation;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReference;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReferenceInDelegation;
import io.ciera.tool.sql.ooaofooa.component.impl.DelegationImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceReferenceImpl;


public class InterfaceReferenceInDelegationImpl extends ModelInstance<InterfaceReferenceInDelegation,Sql> implements InterfaceReferenceInDelegation {

    public static final String KEY_LETTERS = "C_RID";
    public static final InterfaceReferenceInDelegation EMPTY_INTERFACEREFERENCEINDELEGATION = new EmptyInterfaceReferenceInDelegation();

    private Sql context;

    // constructors
    private InterfaceReferenceInDelegationImpl( Sql context ) {
        this.context = context;
        ref_Reference_Id = UniqueId.random();
        ref_Delegation_Id = UniqueId.random();
        R4013_handles_delegation_for_InterfaceReference_inst = InterfaceReferenceImpl.EMPTY_INTERFACEREFERENCE;
        R4013_may_delegate_through_Delegation_inst = DelegationImpl.EMPTY_DELEGATION;
    }

    private InterfaceReferenceInDelegationImpl( Sql context, UniqueId instanceId, UniqueId ref_Reference_Id, UniqueId ref_Delegation_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Reference_Id = ref_Reference_Id;
        this.ref_Delegation_Id = ref_Delegation_Id;
        R4013_handles_delegation_for_InterfaceReference_inst = InterfaceReferenceImpl.EMPTY_INTERFACEREFERENCE;
        R4013_may_delegate_through_Delegation_inst = DelegationImpl.EMPTY_DELEGATION;
    }

    public static InterfaceReferenceInDelegation create( Sql context ) throws XtumlException {
        InterfaceReferenceInDelegation newInterfaceReferenceInDelegation = new InterfaceReferenceInDelegationImpl( context );
        if ( context.addInstance( newInterfaceReferenceInDelegation ) ) {
            newInterfaceReferenceInDelegation.getRunContext().addChange(new InstanceCreatedDelta(newInterfaceReferenceInDelegation, KEY_LETTERS));
            return newInterfaceReferenceInDelegation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InterfaceReferenceInDelegation create( Sql context, UniqueId instanceId, UniqueId ref_Reference_Id, UniqueId ref_Delegation_Id ) throws XtumlException {
        InterfaceReferenceInDelegation newInterfaceReferenceInDelegation = new InterfaceReferenceInDelegationImpl( context, instanceId, ref_Reference_Id, ref_Delegation_Id );
        if ( context.addInstance( newInterfaceReferenceInDelegation ) ) {
            return newInterfaceReferenceInDelegation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Reference_Id;
    @Override
    public void setReference_Id( UniqueId ref_Reference_Id ) throws XtumlException {
        checkLiving();
        if ( ref_Reference_Id.inequality( this.ref_Reference_Id ) ) {
            final UniqueId oldValue = this.ref_Reference_Id;
            this.ref_Reference_Id = ref_Reference_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Reference_Id", oldValue, this.ref_Reference_Id));
        }
    }
    @Override
    public UniqueId getReference_Id() throws XtumlException {
        checkLiving();
                return ref_Reference_Id;
    }
    private UniqueId ref_Delegation_Id;
    @Override
    public void setDelegation_Id( UniqueId ref_Delegation_Id ) throws XtumlException {
        checkLiving();
        if ( ref_Delegation_Id.inequality( this.ref_Delegation_Id ) ) {
            final UniqueId oldValue = this.ref_Delegation_Id;
            this.ref_Delegation_Id = ref_Delegation_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Delegation_Id", oldValue, this.ref_Delegation_Id));
        }
    }
    @Override
    public UniqueId getDelegation_Id() throws XtumlException {
        checkLiving();
                return ref_Delegation_Id;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getReference_Id(), getDelegation_Id());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private InterfaceReference R4013_handles_delegation_for_InterfaceReference_inst;
    @Override
    public void setR4013_handles_delegation_for_InterfaceReference( InterfaceReference inst ) {
        R4013_handles_delegation_for_InterfaceReference_inst = inst;
    }
    @Override
    public InterfaceReference R4013_handles_delegation_for_InterfaceReference() throws XtumlException {
        return R4013_handles_delegation_for_InterfaceReference_inst;
    }
    private Delegation R4013_may_delegate_through_Delegation_inst;
    @Override
    public void setR4013_may_delegate_through_Delegation( Delegation inst ) {
        R4013_may_delegate_through_Delegation_inst = inst;
    }
    @Override
    public Delegation R4013_may_delegate_through_Delegation() throws XtumlException {
        return R4013_may_delegate_through_Delegation_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InterfaceReferenceInDelegation value() {
        return this;
    }

    @Override
    public InterfaceReferenceInDelegation self() {
        return this;
    }

    @Override
    public InterfaceReferenceInDelegation oneWhere( IWhere<InterfaceReferenceInDelegation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_INTERFACEREFERENCEINDELEGATION;
    }

}

class EmptyInterfaceReferenceInDelegation extends ModelInstance<InterfaceReferenceInDelegation,Sql> implements InterfaceReferenceInDelegation {

    // attributes
    public void setReference_Id( UniqueId ref_Reference_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getReference_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDelegation_Id( UniqueId ref_Delegation_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDelegation_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public InterfaceReference R4013_handles_delegation_for_InterfaceReference() {
        return InterfaceReferenceImpl.EMPTY_INTERFACEREFERENCE;
    }
    @Override
    public Delegation R4013_may_delegate_through_Delegation() {
        return DelegationImpl.EMPTY_DELEGATION;
    }


    @Override
    public String getKeyLetters() {
        return InterfaceReferenceInDelegationImpl.KEY_LETTERS;
    }

    @Override
    public InterfaceReferenceInDelegation value() {
        return this;
    }
    
    @Override
    public InterfaceReferenceInDelegation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InterfaceReferenceInDelegation oneWhere( IWhere<InterfaceReferenceInDelegation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return InterfaceReferenceInDelegationImpl.EMPTY_INTERFACEREFERENCEINDELEGATION;
    }

}
