package io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.Delegation;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReference;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedProvision;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedReference;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedRequirement;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.PortReference;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedProvisionImpl;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedRequirementImpl;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.PortReferenceImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.DelegationImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceReferenceImpl;


public class ImportedReferenceImpl extends ModelInstance<ImportedReference,Sql> implements ImportedReference {

    public static final String KEY_LETTERS = "CL_IIR";
    public static final ImportedReference EMPTY_IMPORTEDREFERENCE = new EmptyImportedReference();

    private Sql context;

    // constructors
    private ImportedReferenceImpl( Sql context ) {
        this.context = context;
        m_Id = UniqueId.random();
        ref_Ref_Id = UniqueId.random();
        ref_CL_POR_Id = UniqueId.random();
        ref_Delegation_Id = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        R4701_imports_InterfaceReference_inst = InterfaceReferenceImpl.EMPTY_INTERFACEREFERENCE;
        R4703_is_a_ImportedProvision_inst = ImportedProvisionImpl.EMPTY_IMPORTEDPROVISION;
        R4703_is_a_ImportedRequirement_inst = ImportedRequirementImpl.EMPTY_IMPORTEDREQUIREMENT;
        R4704_accepts_communication_through_Delegation_inst = DelegationImpl.EMPTY_DELEGATION;
        R4708_originates_from_PortReference_inst = PortReferenceImpl.EMPTY_PORTREFERENCE;
    }

    private ImportedReferenceImpl( Sql context, UniqueId instanceId, UniqueId m_Id, UniqueId ref_Ref_Id, UniqueId ref_CL_POR_Id, UniqueId ref_Delegation_Id, String m_Name, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.m_Id = m_Id;
        this.ref_Ref_Id = ref_Ref_Id;
        this.ref_CL_POR_Id = ref_CL_POR_Id;
        this.ref_Delegation_Id = ref_Delegation_Id;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        R4701_imports_InterfaceReference_inst = InterfaceReferenceImpl.EMPTY_INTERFACEREFERENCE;
        R4703_is_a_ImportedProvision_inst = ImportedProvisionImpl.EMPTY_IMPORTEDPROVISION;
        R4703_is_a_ImportedRequirement_inst = ImportedRequirementImpl.EMPTY_IMPORTEDREQUIREMENT;
        R4704_accepts_communication_through_Delegation_inst = DelegationImpl.EMPTY_DELEGATION;
        R4708_originates_from_PortReference_inst = PortReferenceImpl.EMPTY_PORTREFERENCE;
    }

    public static ImportedReference create( Sql context ) throws XtumlException {
        ImportedReference newImportedReference = new ImportedReferenceImpl( context );
        if ( context.addInstance( newImportedReference ) ) {
            newImportedReference.getRunContext().addChange(new InstanceCreatedDelta(newImportedReference, KEY_LETTERS));
            return newImportedReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ImportedReference create( Sql context, UniqueId instanceId, UniqueId m_Id, UniqueId ref_Ref_Id, UniqueId ref_CL_POR_Id, UniqueId ref_Delegation_Id, String m_Name, String m_Descrip ) throws XtumlException {
        ImportedReference newImportedReference = new ImportedReferenceImpl( context, instanceId, m_Id, ref_Ref_Id, ref_CL_POR_Id, ref_Delegation_Id, m_Name, m_Descrip );
        if ( context.addInstance( newImportedReference ) ) {
            return newImportedReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
                return m_Id;
    }
    @Override
    public void setId( UniqueId m_Id ) throws XtumlException {
        checkLiving();
        if ( m_Id.inequality( this.m_Id ) ) {
            final UniqueId oldValue = this.m_Id;
            this.m_Id = m_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Id", oldValue, this.m_Id));
            if ( !R4703_is_a_ImportedProvision().isEmpty() ) R4703_is_a_ImportedProvision().setId( m_Id );
            if ( !R4703_is_a_ImportedRequirement().isEmpty() ) R4703_is_a_ImportedRequirement().setId( m_Id );
        }
    }
    private UniqueId ref_Ref_Id;
    @Override
    public UniqueId getRef_Id() throws XtumlException {
        checkLiving();
                return ref_Ref_Id;
    }
    @Override
    public void setRef_Id( UniqueId ref_Ref_Id ) throws XtumlException {
        checkLiving();
        if ( ref_Ref_Id.inequality( this.ref_Ref_Id ) ) {
            final UniqueId oldValue = this.ref_Ref_Id;
            this.ref_Ref_Id = ref_Ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Ref_Id", oldValue, this.ref_Ref_Id));
        }
    }
    private UniqueId ref_CL_POR_Id;
    @Override
    public void setCL_POR_Id( UniqueId ref_CL_POR_Id ) throws XtumlException {
        checkLiving();
        if ( ref_CL_POR_Id.inequality( this.ref_CL_POR_Id ) ) {
            final UniqueId oldValue = this.ref_CL_POR_Id;
            this.ref_CL_POR_Id = ref_CL_POR_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_CL_POR_Id", oldValue, this.ref_CL_POR_Id));
        }
    }
    @Override
    public UniqueId getCL_POR_Id() throws XtumlException {
        checkLiving();
                return ref_CL_POR_Id;
    }
    private UniqueId ref_Delegation_Id;
    @Override
    public UniqueId getDelegation_Id() throws XtumlException {
        checkLiving();
                return ref_Delegation_Id;
    }
    @Override
    public void setDelegation_Id( UniqueId ref_Delegation_Id ) throws XtumlException {
        checkLiving();
        if ( ref_Delegation_Id.inequality( this.ref_Delegation_Id ) ) {
            final UniqueId oldValue = this.ref_Delegation_Id;
            this.ref_Delegation_Id = ref_Delegation_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Delegation_Id", oldValue, this.ref_Delegation_Id));
        }
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return m_Name;
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Name, this.m_Name ) ) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private String m_Descrip;
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Descrip, this.m_Descrip ) ) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
                return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private InterfaceReference R4701_imports_InterfaceReference_inst;
    @Override
    public void setR4701_imports_InterfaceReference( InterfaceReference inst ) {
        R4701_imports_InterfaceReference_inst = inst;
    }
    @Override
    public InterfaceReference R4701_imports_InterfaceReference() throws XtumlException {
        return R4701_imports_InterfaceReference_inst;
    }
    private ImportedProvision R4703_is_a_ImportedProvision_inst;
    @Override
    public void setR4703_is_a_ImportedProvision( ImportedProvision inst ) {
        R4703_is_a_ImportedProvision_inst = inst;
    }
    @Override
    public ImportedProvision R4703_is_a_ImportedProvision() throws XtumlException {
        return R4703_is_a_ImportedProvision_inst;
    }
    private ImportedRequirement R4703_is_a_ImportedRequirement_inst;
    @Override
    public void setR4703_is_a_ImportedRequirement( ImportedRequirement inst ) {
        R4703_is_a_ImportedRequirement_inst = inst;
    }
    @Override
    public ImportedRequirement R4703_is_a_ImportedRequirement() throws XtumlException {
        return R4703_is_a_ImportedRequirement_inst;
    }
    private Delegation R4704_accepts_communication_through_Delegation_inst;
    @Override
    public void setR4704_accepts_communication_through_Delegation( Delegation inst ) {
        R4704_accepts_communication_through_Delegation_inst = inst;
    }
    @Override
    public Delegation R4704_accepts_communication_through_Delegation() throws XtumlException {
        return R4704_accepts_communication_through_Delegation_inst;
    }
    private PortReference R4708_originates_from_PortReference_inst;
    @Override
    public void setR4708_originates_from_PortReference( PortReference inst ) {
        R4708_originates_from_PortReference_inst = inst;
    }
    @Override
    public PortReference R4708_originates_from_PortReference() throws XtumlException {
        return R4708_originates_from_PortReference_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ImportedReference value() {
        return this;
    }

    @Override
    public ImportedReference self() {
        return this;
    }

    @Override
    public ImportedReference oneWhere( IWhere<ImportedReference> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_IMPORTEDREFERENCE;
    }

}

class EmptyImportedReference extends ModelInstance<ImportedReference,Sql> implements ImportedReference {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId m_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRef_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRef_Id( UniqueId ref_Ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setCL_POR_Id( UniqueId ref_CL_POR_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getCL_POR_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getDelegation_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDelegation_Id( UniqueId ref_Delegation_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public InterfaceReference R4701_imports_InterfaceReference() {
        return InterfaceReferenceImpl.EMPTY_INTERFACEREFERENCE;
    }
    @Override
    public ImportedProvision R4703_is_a_ImportedProvision() {
        return ImportedProvisionImpl.EMPTY_IMPORTEDPROVISION;
    }
    @Override
    public ImportedRequirement R4703_is_a_ImportedRequirement() {
        return ImportedRequirementImpl.EMPTY_IMPORTEDREQUIREMENT;
    }
    @Override
    public Delegation R4704_accepts_communication_through_Delegation() {
        return DelegationImpl.EMPTY_DELEGATION;
    }
    @Override
    public PortReference R4708_originates_from_PortReference() {
        return PortReferenceImpl.EMPTY_PORTREFERENCE;
    }


    @Override
    public String getKeyLetters() {
        return ImportedReferenceImpl.KEY_LETTERS;
    }

    @Override
    public ImportedReference value() {
        return this;
    }
    
    @Override
    public ImportedReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ImportedReference oneWhere( IWhere<ImportedReference> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return ImportedReferenceImpl.EMPTY_IMPORTEDREFERENCE;
    }

}
