package io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedProvision;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedProvisionInSatisfactionSet;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedProvisionSet;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedReferenceSet;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedProvisionInSatisfactionSetImpl;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedReferenceSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ImportedProvisionSetImpl extends InstanceSet<ImportedProvisionSet,ImportedProvision> implements ImportedProvisionSet {

    public ImportedProvisionSetImpl() {
    }

    public ImportedProvisionSetImpl(Comparator<? super ImportedProvision> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setId( UniqueId ref_Id ) throws XtumlException {
        for ( ImportedProvision importedprovision : this ) importedprovision.setId( ref_Id );
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( ImportedProvision importedprovision : this ) importedprovision.setDescrip( m_Descrip );
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( ImportedProvision importedprovision : this ) importedprovision.setName( m_Name );
    }


    // selections
    @Override
    public ImportedReferenceSet R4703_is_a_ImportedReference() throws XtumlException {
        ImportedReferenceSet importedreferenceset = new ImportedReferenceSetImpl();
        for ( ImportedProvision importedprovision : this ) importedreferenceset.add( importedprovision.R4703_is_a_ImportedReference() );
        return importedreferenceset;
    }
    @Override
    public ImportedProvisionInSatisfactionSet R4705_provides_satisfaction_through_ImportedProvisionInSatisfaction() throws XtumlException {
        ImportedProvisionInSatisfactionSet importedprovisioninsatisfactionset = new ImportedProvisionInSatisfactionSetImpl();
        for ( ImportedProvision importedprovision : this ) importedprovisioninsatisfactionset.addAll( importedprovision.R4705_provides_satisfaction_through_ImportedProvisionInSatisfaction() );
        return importedprovisioninsatisfactionset;
    }


    @Override
    public ImportedProvision nullElement() {
        return ImportedProvisionImpl.EMPTY_IMPORTEDPROVISION;
    }

    @Override
    public ImportedProvisionSet emptySet() {
      return new ImportedProvisionSetImpl();
    }

    @Override
    public ImportedProvisionSet emptySet(Comparator<? super ImportedProvision> comp) {
      return new ImportedProvisionSetImpl(comp);
    }

    @Override
    public ImportedProvisionSet value() {
        return this;
    }

    @Override
    public List<ImportedProvision> elements() {
        ImportedProvision[] elements = toArray(new ImportedProvision[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
