package io.ciera.tool.sql.ooaofooa.activity.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.activity.ActionNode;
import io.ciera.tool.sql.ooaofooa.activity.SendSignal;
import io.ciera.tool.sql.ooaofooa.activity.impl.ActionNodeImpl;


public class SendSignalImpl extends ModelInstance<SendSignal,Sql> implements SendSignal {

    public static final String KEY_LETTERS = "A_SS";
    public static final SendSignal EMPTY_SENDSIGNAL = new EmptySendSignal();

    private Sql context;

    // constructors
    private SendSignalImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        R1107_is_a_ActionNode_inst = ActionNodeImpl.EMPTY_ACTIONNODE;
    }

    private SendSignalImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        R1107_is_a_ActionNode_inst = ActionNodeImpl.EMPTY_ACTIONNODE;
    }

    public static SendSignal create( Sql context ) throws XtumlException {
        SendSignal newSendSignal = new SendSignalImpl( context );
        if ( context.addInstance( newSendSignal ) ) {
            newSendSignal.getRunContext().addChange(new InstanceCreatedDelta(newSendSignal, KEY_LETTERS));
            return newSendSignal;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SendSignal create( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip ) throws XtumlException {
        SendSignal newSendSignal = new SendSignalImpl( context, instanceId, ref_Id, m_Name, m_Descrip );
        if ( context.addInstance( newSendSignal ) ) {
            return newSendSignal;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
                return ref_Id;
    }
    @Override
    public void setId( UniqueId ref_Id ) throws XtumlException {
        checkLiving();
        if ( ref_Id.inequality( this.ref_Id ) ) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
        }
    }
    private String m_Name;
    @Override
    public void setName( String m_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Name, this.m_Name ) ) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return m_Name;
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
                return m_Descrip;
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Descrip, this.m_Descrip ) ) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ActionNode R1107_is_a_ActionNode_inst;
    @Override
    public void setR1107_is_a_ActionNode( ActionNode inst ) {
        R1107_is_a_ActionNode_inst = inst;
    }
    @Override
    public ActionNode R1107_is_a_ActionNode() throws XtumlException {
        return R1107_is_a_ActionNode_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SendSignal value() {
        return this;
    }

    @Override
    public SendSignal self() {
        return this;
    }

    @Override
    public SendSignal oneWhere( IWhere<SendSignal> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_SENDSIGNAL;
    }

}

class EmptySendSignal extends ModelInstance<SendSignal,Sql> implements SendSignal {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ActionNode R1107_is_a_ActionNode() {
        return ActionNodeImpl.EMPTY_ACTIONNODE;
    }


    @Override
    public String getKeyLetters() {
        return SendSignalImpl.KEY_LETTERS;
    }

    @Override
    public SendSignal value() {
        return this;
    }
    
    @Override
    public SendSignal self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SendSignal oneWhere( IWhere<SendSignal> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return SendSignalImpl.EMPTY_SENDSIGNAL;
    }

}
