package io.ciera.tool.sql.ooaofooa.activity.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.activity.ActivityNodeSet;
import io.ciera.tool.sql.ooaofooa.activity.ObjectNode;
import io.ciera.tool.sql.ooaofooa.activity.ObjectNodeSet;
import io.ciera.tool.sql.ooaofooa.activity.impl.ActivityNodeSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ObjectNodeSetImpl extends InstanceSet<ObjectNodeSet,ObjectNode> implements ObjectNodeSet {

    public ObjectNodeSetImpl() {
    }

    public ObjectNodeSetImpl(Comparator<? super ObjectNode> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( ObjectNode objectnode : this ) objectnode.setDescrip( m_Descrip );
    }
    @Override
    public void setId( UniqueId ref_Id ) throws XtumlException {
        for ( ObjectNode objectnode : this ) objectnode.setId( ref_Id );
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( ObjectNode objectnode : this ) objectnode.setName( m_Name );
    }


    // selections
    @Override
    public ActivityNodeSet R1105_is_a_ActivityNode() throws XtumlException {
        ActivityNodeSet activitynodeset = new ActivityNodeSetImpl();
        for ( ObjectNode objectnode : this ) activitynodeset.add( objectnode.R1105_is_a_ActivityNode() );
        return activitynodeset;
    }


    @Override
    public ObjectNode nullElement() {
        return ObjectNodeImpl.EMPTY_OBJECTNODE;
    }

    @Override
    public ObjectNodeSet emptySet() {
      return new ObjectNodeSetImpl();
    }

    @Override
    public ObjectNodeSet emptySet(Comparator<? super ObjectNode> comp) {
      return new ObjectNodeSetImpl(comp);
    }

    @Override
    public ObjectNodeSet value() {
        return this;
    }

    @Override
    public List<ObjectNode> elements() {
        ObjectNode[] elements = toArray(new ObjectNode[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
