package io.ciera.tool.sql.ooaofooa.activity.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.activity.ActivityNode;
import io.ciera.tool.sql.ooaofooa.activity.ObjectNode;
import io.ciera.tool.sql.ooaofooa.activity.impl.ActivityNodeImpl;


public class ObjectNodeImpl extends ModelInstance<ObjectNode,Sql> implements ObjectNode {

    public static final String KEY_LETTERS = "A_OBJ";
    public static final ObjectNode EMPTY_OBJECTNODE = new EmptyObjectNode();

    private Sql context;

    // constructors
    private ObjectNodeImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        R1105_is_a_ActivityNode_inst = ActivityNodeImpl.EMPTY_ACTIVITYNODE;
    }

    private ObjectNodeImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        R1105_is_a_ActivityNode_inst = ActivityNodeImpl.EMPTY_ACTIVITYNODE;
    }

    public static ObjectNode create( Sql context ) throws XtumlException {
        ObjectNode newObjectNode = new ObjectNodeImpl( context );
        if ( context.addInstance( newObjectNode ) ) {
            newObjectNode.getRunContext().addChange(new InstanceCreatedDelta(newObjectNode, KEY_LETTERS));
            return newObjectNode;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ObjectNode create( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip ) throws XtumlException {
        ObjectNode newObjectNode = new ObjectNodeImpl( context, instanceId, ref_Id, m_Name, m_Descrip );
        if ( context.addInstance( newObjectNode ) ) {
            return newObjectNode;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public void setId( UniqueId ref_Id ) throws XtumlException {
        checkLiving();
        if ( ref_Id.inequality( this.ref_Id ) ) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
                return ref_Id;
    }
    private String m_Name;
    @Override
    public void setName( String m_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Name, this.m_Name ) ) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return m_Name;
    }
    private String m_Descrip;
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Descrip, this.m_Descrip ) ) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
                return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ActivityNode R1105_is_a_ActivityNode_inst;
    @Override
    public void setR1105_is_a_ActivityNode( ActivityNode inst ) {
        R1105_is_a_ActivityNode_inst = inst;
    }
    @Override
    public ActivityNode R1105_is_a_ActivityNode() throws XtumlException {
        return R1105_is_a_ActivityNode_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ObjectNode value() {
        return this;
    }

    @Override
    public ObjectNode self() {
        return this;
    }

    @Override
    public ObjectNode oneWhere( IWhere<ObjectNode> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_OBJECTNODE;
    }

}

class EmptyObjectNode extends ModelInstance<ObjectNode,Sql> implements ObjectNode {

    // attributes
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ActivityNode R1105_is_a_ActivityNode() {
        return ActivityNodeImpl.EMPTY_ACTIVITYNODE;
    }


    @Override
    public String getKeyLetters() {
        return ObjectNodeImpl.KEY_LETTERS;
    }

    @Override
    public ObjectNode value() {
        return this;
    }
    
    @Override
    public ObjectNode self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ObjectNode oneWhere( IWhere<ObjectNode> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return ObjectNodeImpl.EMPTY_OBJECTNODE;
    }

}
