package io.ciera.tool.sql.ooaofooa.activity.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.activity.AcceptEvent;
import io.ciera.tool.sql.ooaofooa.activity.AcceptTimeEventAction;
import io.ciera.tool.sql.ooaofooa.activity.impl.AcceptEventImpl;


public class AcceptTimeEventActionImpl extends ModelInstance<AcceptTimeEventAction,Sql> implements AcceptTimeEventAction {

    public static final String KEY_LETTERS = "A_ATE";
    public static final AcceptTimeEventAction EMPTY_ACCEPTTIMEEVENTACTION = new EmptyAcceptTimeEventAction();

    private Sql context;

    // constructors
    private AcceptTimeEventActionImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        R1112_is_a_AcceptEvent_inst = AcceptEventImpl.EMPTY_ACCEPTEVENT;
    }

    private AcceptTimeEventActionImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        R1112_is_a_AcceptEvent_inst = AcceptEventImpl.EMPTY_ACCEPTEVENT;
    }

    public static AcceptTimeEventAction create( Sql context ) throws XtumlException {
        AcceptTimeEventAction newAcceptTimeEventAction = new AcceptTimeEventActionImpl( context );
        if ( context.addInstance( newAcceptTimeEventAction ) ) {
            newAcceptTimeEventAction.getRunContext().addChange(new InstanceCreatedDelta(newAcceptTimeEventAction, KEY_LETTERS));
            return newAcceptTimeEventAction;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static AcceptTimeEventAction create( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name, String m_Descrip ) throws XtumlException {
        AcceptTimeEventAction newAcceptTimeEventAction = new AcceptTimeEventActionImpl( context, instanceId, ref_Id, m_Name, m_Descrip );
        if ( context.addInstance( newAcceptTimeEventAction ) ) {
            return newAcceptTimeEventAction;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public void setId( UniqueId ref_Id ) throws XtumlException {
        checkLiving();
        if ( ref_Id.inequality( this.ref_Id ) ) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
                return ref_Id;
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return m_Name;
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Name, this.m_Name ) ) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private String m_Descrip;
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Descrip, this.m_Descrip ) ) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
                return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private AcceptEvent R1112_is_a_AcceptEvent_inst;
    @Override
    public void setR1112_is_a_AcceptEvent( AcceptEvent inst ) {
        R1112_is_a_AcceptEvent_inst = inst;
    }
    @Override
    public AcceptEvent R1112_is_a_AcceptEvent() throws XtumlException {
        return R1112_is_a_AcceptEvent_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public AcceptTimeEventAction value() {
        return this;
    }

    @Override
    public AcceptTimeEventAction self() {
        return this;
    }

    @Override
    public AcceptTimeEventAction oneWhere( IWhere<AcceptTimeEventAction> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_ACCEPTTIMEEVENTACTION;
    }

}

class EmptyAcceptTimeEventAction extends ModelInstance<AcceptTimeEventAction,Sql> implements AcceptTimeEventAction {

    // attributes
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public AcceptEvent R1112_is_a_AcceptEvent() {
        return AcceptEventImpl.EMPTY_ACCEPTEVENT;
    }


    @Override
    public String getKeyLetters() {
        return AcceptTimeEventActionImpl.KEY_LETTERS;
    }

    @Override
    public AcceptTimeEventAction value() {
        return this;
    }
    
    @Override
    public AcceptTimeEventAction self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public AcceptTimeEventAction oneWhere( IWhere<AcceptTimeEventAction> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return AcceptTimeEventActionImpl.EMPTY_ACCEPTTIMEEVENTACTION;
    }

}
