package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.loader.AttributeSerializerSet;
import io.ciera.tool.sql.loader.StringSerializer;
import io.ciera.tool.sql.loader.StringSerializerSet;
import io.ciera.tool.sql.loader.impl.AttributeSerializerSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class StringSerializerSetImpl extends InstanceSet<StringSerializerSet,StringSerializer> implements StringSerializerSet {

    public StringSerializerSetImpl() {
    }

    public StringSerializerSetImpl(Comparator<? super StringSerializer> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        for ( StringSerializer stringserializer : this ) stringserializer.setAttr_name( ref_attr_name );
    }
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        for ( StringSerializer stringserializer : this ) stringserializer.setLoader_package( ref_loader_package );
    }
    @Override
    public void setValue( String m_value ) throws XtumlException {
        for ( StringSerializer stringserializer : this ) stringserializer.setValue( m_value );
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        for ( StringSerializer stringserializer : this ) stringserializer.setClass_name( ref_class_name );
    }
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        for ( StringSerializer stringserializer : this ) stringserializer.setLoader_name( ref_loader_name );
    }


    // selections
    @Override
    public AttributeSerializerSet R3004_is_a_AttributeSerializer() throws XtumlException {
        AttributeSerializerSet attributeserializerset = new AttributeSerializerSetImpl();
        for ( StringSerializer stringserializer : this ) attributeserializerset.add( stringserializer.R3004_is_a_AttributeSerializer() );
        return attributeserializerset;
    }


    @Override
    public StringSerializer nullElement() {
        return StringSerializerImpl.EMPTY_STRINGSERIALIZER;
    }

    @Override
    public StringSerializerSet emptySet() {
      return new StringSerializerSetImpl();
    }

    @Override
    public StringSerializerSet emptySet(Comparator<? super StringSerializer> comp) {
      return new StringSerializerSetImpl(comp);
    }

    @Override
    public StringSerializerSet value() {
        return this;
    }

    @Override
    public List<StringSerializer> elements() {
        return Arrays.asList(toArray(new StringSerializer[0]));
    }

}
