package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.classes.ModelInstSet;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstSetImpl;
import io.ciera.tool.sql.loader.EventInstanceLoader;
import io.ciera.tool.sql.loader.EventInstanceLoaderSet;
import io.ciera.tool.sql.loader.InstanceLoaderSet;
import io.ciera.tool.sql.loader.impl.InstanceLoaderSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class EventInstanceLoaderSetImpl extends InstanceSet<EventInstanceLoaderSet,EventInstanceLoader> implements EventInstanceLoaderSet {

    public EventInstanceLoaderSetImpl() {
    }

    public EventInstanceLoaderSetImpl(Comparator<? super EventInstanceLoader> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        for ( EventInstanceLoader eventinstanceloader : this ) eventinstanceloader.setComp_package( ref_comp_package );
    }
    @Override
    public void setClass_package( String ref_class_package ) throws XtumlException {
        for ( EventInstanceLoader eventinstanceloader : this ) eventinstanceloader.setClass_package( ref_class_package );
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        for ( EventInstanceLoader eventinstanceloader : this ) eventinstanceloader.setClass_name( ref_class_name );
    }
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        for ( EventInstanceLoader eventinstanceloader : this ) eventinstanceloader.setLoader_name( ref_loader_name );
    }
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        for ( EventInstanceLoader eventinstanceloader : this ) eventinstanceloader.setLoader_package( ref_loader_package );
    }
    @Override
    public void setEvt_class_name( String ref_evt_class_name ) throws XtumlException {
        for ( EventInstanceLoader eventinstanceloader : this ) eventinstanceloader.setEvt_class_name( ref_evt_class_name );
    }
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        for ( EventInstanceLoader eventinstanceloader : this ) eventinstanceloader.setComp_name( ref_comp_name );
    }


    // selections
    @Override
    public InstanceLoaderSet R3016_is_a_InstanceLoader() throws XtumlException {
        InstanceLoaderSet instanceloaderset = new InstanceLoaderSetImpl();
        for ( EventInstanceLoader eventinstanceloader : this ) instanceloaderset.add( eventinstanceloader.R3016_is_a_InstanceLoader() );
        return instanceloaderset;
    }
    @Override
    public ModelInstSet R3017_ModelInst() throws XtumlException {
        ModelInstSet modelinstset = new ModelInstSetImpl();
        for ( EventInstanceLoader eventinstanceloader : this ) modelinstset.add( eventinstanceloader.R3017_ModelInst() );
        return modelinstset;
    }


    @Override
    public EventInstanceLoader nullElement() {
        return EventInstanceLoaderImpl.EMPTY_EVENTINSTANCELOADER;
    }

    @Override
    public EventInstanceLoaderSet emptySet() {
      return new EventInstanceLoaderSetImpl();
    }

    @Override
    public EventInstanceLoaderSet emptySet(Comparator<? super EventInstanceLoader> comp) {
      return new EventInstanceLoaderSetImpl(comp);
    }

    @Override
    public EventInstanceLoaderSet value() {
        return this;
    }

    @Override
    public List<EventInstanceLoader> elements() {
        return Arrays.asList(toArray(new EventInstanceLoader[0]));
    }

}
