package io.ciera.tool.sql.loader;


import io.ciera.runtime.summit.classes.IModelInstance;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.AttributeSerializer;
import io.ciera.tool.sql.loader.AttributeSerializerSet;
import io.ciera.tool.sql.loader.ClassInstanceSerializer;
import io.ciera.tool.sql.loader.EventInstanceSerializer;
import io.ciera.tool.sql.loader.PopulationLoader;
import io.ciera.tool.sql.loader.TimerInstanceSerializer;


public interface InstanceSerializer extends IModelInstance<InstanceSerializer,Sql> {

    // attributes
    public void setLoader_name( String ref_loader_name ) throws XtumlException;
    public String getLoader_name() throws XtumlException;
    public void setLoader_package( String ref_loader_package ) throws XtumlException;
    public String getLoader_package() throws XtumlException;
    public void setClass_name( String m_class_name ) throws XtumlException;
    public String getClass_name() throws XtumlException;


    // operations
    public void render() throws XtumlException;
    public void render_def() throws XtumlException;
    public void render_init() throws XtumlException;


    // selections
    default public void setR3001_invoked_by_PopulationLoader( PopulationLoader inst ) {}
    public PopulationLoader R3001_invoked_by_PopulationLoader() throws XtumlException;
    default public void addR3002_serializes_data_value_using_AttributeSerializer( AttributeSerializer inst ) {}
    default public void removeR3002_serializes_data_value_using_AttributeSerializer( AttributeSerializer inst ) {}
    public AttributeSerializerSet R3002_serializes_data_value_using_AttributeSerializer() throws XtumlException;
    default public void setR3015_is_a_ClassInstanceSerializer( ClassInstanceSerializer inst ) {}
    public ClassInstanceSerializer R3015_is_a_ClassInstanceSerializer() throws XtumlException;
    default public void setR3015_is_a_EventInstanceSerializer( EventInstanceSerializer inst ) {}
    public EventInstanceSerializer R3015_is_a_EventInstanceSerializer() throws XtumlException;
    default public void setR3015_is_a_TimerInstanceSerializer( TimerInstanceSerializer inst ) {}
    public TimerInstanceSerializer R3015_is_a_TimerInstanceSerializer() throws XtumlException;


}
