package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.architecture.classes.InstSetSet;
import io.ciera.tool.sql.architecture.classes.ModelInstSet;
import io.ciera.tool.sql.architecture.classes.impl.InstSetSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstSetImpl;
import io.ciera.tool.sql.architecture.type.BuiltInTypeSet;
import io.ciera.tool.sql.architecture.type.EnumeratedTypeSet;
import io.ciera.tool.sql.architecture.type.Type;
import io.ciera.tool.sql.architecture.type.TypeReferenceSet;
import io.ciera.tool.sql.architecture.type.TypeSet;
import io.ciera.tool.sql.architecture.type.UnresolvedTypeSet;
import io.ciera.tool.sql.architecture.type.UserDefinedTypeSet;
import io.ciera.tool.sql.architecture.type.impl.BuiltInTypeSetImpl;
import io.ciera.tool.sql.architecture.type.impl.EnumeratedTypeSetImpl;
import io.ciera.tool.sql.architecture.type.impl.TypeReferenceSetImpl;
import io.ciera.tool.sql.architecture.type.impl.UnresolvedTypeSetImpl;
import io.ciera.tool.sql.architecture.type.impl.UserDefinedTypeSetImpl;
import io.ciera.tool.sql.loader.GeneralLoaderSet;
import io.ciera.tool.sql.loader.GeneralSerializerSet;
import io.ciera.tool.sql.loader.impl.GeneralLoaderSetImpl;
import io.ciera.tool.sql.loader.impl.GeneralSerializerSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.DataTypeSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class TypeSetImpl extends InstanceSet<TypeSet,Type> implements TypeSet {

    public TypeSetImpl() {
    }

    public TypeSetImpl(Comparator<? super Type> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String m_name ) throws XtumlException {
        for ( Type type : this ) type.setName( m_name );
    }
    @Override
    public void setPackage( String m_package ) throws XtumlException {
        for ( Type type : this ) type.setPackage( m_package );
    }
    @Override
    public void setDefault_value( String m_default_value ) throws XtumlException {
        for ( Type type : this ) type.setDefault_value( m_default_value );
    }
    @Override
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        for ( Type type : this ) type.setDT_ID( ref_DT_ID );
    }


    // selections
    @Override
    public GeneralLoaderSet R3013_GeneralLoader() throws XtumlException {
        GeneralLoaderSet generalloaderset = new GeneralLoaderSetImpl();
        for ( Type type : this ) generalloaderset.addAll( type.R3013_GeneralLoader() );
        return generalloaderset;
    }
    @Override
    public GeneralSerializerSet R3014_GeneralSerializer() throws XtumlException {
        GeneralSerializerSet generalserializerset = new GeneralSerializerSetImpl();
        for ( Type type : this ) generalserializerset.addAll( type.R3014_GeneralSerializer() );
        return generalserializerset;
    }
    @Override
    public TypeReferenceSet R3800_referred_to_by_TypeReference() throws XtumlException {
        TypeReferenceSet typereferenceset = new TypeReferenceSetImpl();
        for ( Type type : this ) typereferenceset.addAll( type.R3800_referred_to_by_TypeReference() );
        return typereferenceset;
    }
    @Override
    public UserDefinedTypeSet R3802_used_as_base_for_UserDefinedType() throws XtumlException {
        UserDefinedTypeSet userdefinedtypeset = new UserDefinedTypeSetImpl();
        for ( Type type : this ) userdefinedtypeset.addAll( type.R3802_used_as_base_for_UserDefinedType() );
        return userdefinedtypeset;
    }
    @Override
    public BuiltInTypeSet R407_is_a_BuiltInType() throws XtumlException {
        BuiltInTypeSet builtintypeset = new BuiltInTypeSetImpl();
        for ( Type type : this ) builtintypeset.add( type.R407_is_a_BuiltInType() );
        return builtintypeset;
    }
    @Override
    public EnumeratedTypeSet R407_is_a_EnumeratedType() throws XtumlException {
        EnumeratedTypeSet enumeratedtypeset = new EnumeratedTypeSetImpl();
        for ( Type type : this ) enumeratedtypeset.add( type.R407_is_a_EnumeratedType() );
        return enumeratedtypeset;
    }
    @Override
    public InstSetSet R407_is_a_InstSet() throws XtumlException {
        InstSetSet instsetset = new InstSetSetImpl();
        for ( Type type : this ) instsetset.add( type.R407_is_a_InstSet() );
        return instsetset;
    }
    @Override
    public ModelInstSet R407_is_a_ModelInst() throws XtumlException {
        ModelInstSet modelinstset = new ModelInstSetImpl();
        for ( Type type : this ) modelinstset.add( type.R407_is_a_ModelInst() );
        return modelinstset;
    }
    @Override
    public UnresolvedTypeSet R407_is_a_UnresolvedType() throws XtumlException {
        UnresolvedTypeSet unresolvedtypeset = new UnresolvedTypeSetImpl();
        for ( Type type : this ) unresolvedtypeset.add( type.R407_is_a_UnresolvedType() );
        return unresolvedtypeset;
    }
    @Override
    public UserDefinedTypeSet R407_is_a_UserDefinedType() throws XtumlException {
        UserDefinedTypeSet userdefinedtypeset = new UserDefinedTypeSetImpl();
        for ( Type type : this ) userdefinedtypeset.add( type.R407_is_a_UserDefinedType() );
        return userdefinedtypeset;
    }
    @Override
    public DataTypeSet R423_is_basis_for_DataType() throws XtumlException {
        DataTypeSet datatypeset = new DataTypeSetImpl();
        for ( Type type : this ) datatypeset.add( type.R423_is_basis_for_DataType() );
        return datatypeset;
    }


    @Override
    public Type nullElement() {
        return TypeImpl.EMPTY_TYPE;
    }

    @Override
    public TypeSet emptySet() {
      return new TypeSetImpl();
    }

    @Override
    public TypeSet emptySet(Comparator<? super Type> comp) {
      return new TypeSetImpl(comp);
    }

    @Override
    public TypeSet value() {
        return this;
    }

    @Override
    public List<Type> elements() {
        Type[] elements = toArray(new Type[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
