package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionImpl;
import io.ciera.tool.sql.architecture.invocable.CodeBlock;
import io.ciera.tool.sql.architecture.statement.Generate;
import io.ciera.tool.sql.architecture.statement.Statement;
import io.ciera.tool.sql.architecture.statement.impl.StatementImpl;


public class GenerateImpl extends ModelInstance<Generate,Sql> implements Generate {

    public static final String KEY_LETTERS = "Generate";
    public static final Generate EMPTY_GENERATE = new EmptyGenerate();

    private Sql context;

    // constructors
    private GenerateImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_evt_expression_number = "";
        R451_is_a_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R486_generates_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    private GenerateImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_evt_expression_number ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_evt_expression_number = ref_evt_expression_number;
        R451_is_a_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R486_generates_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    public static Generate create( Sql context ) throws XtumlException {
        Generate newGenerate = new GenerateImpl( context );
        if ( context.addInstance( newGenerate ) ) {
            newGenerate.getRunContext().addChange(new InstanceCreatedDelta(newGenerate, KEY_LETTERS));
            return newGenerate;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Generate create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_evt_expression_number ) throws XtumlException {
        Generate newGenerate = new GenerateImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_evt_expression_number );
        if ( context.addInstance( newGenerate ) ) {
            return newGenerate;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_parent_name, this.ref_parent_name ) ) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
                return ref_parent_name;
    }
    private String ref_parent_package;
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
                return ref_parent_package;
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_parent_package, this.ref_parent_package ) ) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    private String ref_body_name;
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_body_name, this.ref_body_name ) ) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
                return ref_body_name;
    }
    private String ref_block_number;
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
                return ref_block_number;
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_block_number, this.ref_block_number ) ) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    private String ref_statement_number;
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_statement_number, this.ref_statement_number ) ) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
                return ref_statement_number;
    }
    private String ref_evt_expression_number;
    @Override
    public String getEvt_expression_number() throws XtumlException {
        checkLiving();
                return ref_evt_expression_number;
    }
    @Override
    public void setEvt_expression_number( String ref_evt_expression_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_evt_expression_number, this.ref_evt_expression_number ) ) {
            final String oldValue = this.ref_evt_expression_number;
            this.ref_evt_expression_number = ref_evt_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_evt_expression_number", oldValue, this.ref_evt_expression_number));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        Statement smt = self().R451_is_a_Statement();
        String oal = smt.getOal();
        String prefix = smt.getPrefix();
        CodeBlock block = smt.R450_is_contained_by_CodeBlock();
        String indent = context().getIndent( block.getTab_depth() + 1 );
        Expression evt_expression = self().R486_generates_Expression();
        evt_expression.render();
        String evt_expr = context().T().body();
        context().T().pop_buffer();
        context().T().include( "statement/t.generate.java", evt_expr, indent, oal, prefix );
    }



    // static operations


    // events


    // selections
    private Statement R451_is_a_Statement_inst;
    @Override
    public void setR451_is_a_Statement( Statement inst ) {
        R451_is_a_Statement_inst = inst;
    }
    @Override
    public Statement R451_is_a_Statement() throws XtumlException {
        return R451_is_a_Statement_inst;
    }
    private Expression R486_generates_Expression_inst;
    @Override
    public void setR486_generates_Expression( Expression inst ) {
        R486_generates_Expression_inst = inst;
    }
    @Override
    public Expression R486_generates_Expression() throws XtumlException {
        return R486_generates_Expression_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Generate value() {
        return this;
    }

    @Override
    public Generate self() {
        return this;
    }

    @Override
    public Generate oneWhere( IWhere<Generate> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_GENERATE;
    }

}

class EmptyGenerate extends ModelInstance<Generate,Sql> implements Generate {

    // attributes
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getEvt_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEvt_expression_number( String ref_evt_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Statement R451_is_a_Statement() {
        return StatementImpl.EMPTY_STATEMENT;
    }
    @Override
    public Expression R486_generates_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }


    @Override
    public String getKeyLetters() {
        return GenerateImpl.KEY_LETTERS;
    }

    @Override
    public Generate value() {
        return this;
    }
    
    @Override
    public Generate self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Generate oneWhere( IWhere<Generate> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return GenerateImpl.EMPTY_GENERATE;
    }

}
