package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.Attribute;
import io.ciera.tool.sql.architecture.classes.AttributeAccessor;
import io.ciera.tool.sql.architecture.classes.impl.AttributeImpl;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.Where;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionImpl;
import io.ciera.tool.sql.architecture.type.Type;

import types.AttributeAccessorType;
import types.SortType;


public class WhereImpl extends ModelInstance<Where,Sql> implements Where {

    public static final String KEY_LETTERS = "WhereExpr";
    public static final Where EMPTY_WHERE = new EmptyWhere();

    private Sql context;

    // constructors
    private WhereImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_expression_number = "";
        ref_base_expression_number = "";
        ref_where_expression_number = "";
        m_multiplicity = "";
        m_sorted = SortType.UNINITIALIZED_ENUM;
        m_cast = "";
        ref_attr_name = "";
        ref_attr_class_package = "";
        ref_attr_class_name = "";
        R3906_sorts_set_by_Attribute_inst = AttributeImpl.EMPTY_ATTRIBUTE;
        R776_is_a_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R790_filters_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R796_has_condition_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    private WhereImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_base_expression_number, String ref_where_expression_number, String m_multiplicity, SortType m_sorted, String m_cast, String ref_attr_name, String ref_attr_class_package, String ref_attr_class_name ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_expression_number = ref_expression_number;
        this.ref_base_expression_number = ref_base_expression_number;
        this.ref_where_expression_number = ref_where_expression_number;
        this.m_multiplicity = m_multiplicity;
        this.m_sorted = m_sorted;
        this.m_cast = m_cast;
        this.ref_attr_name = ref_attr_name;
        this.ref_attr_class_package = ref_attr_class_package;
        this.ref_attr_class_name = ref_attr_class_name;
        R3906_sorts_set_by_Attribute_inst = AttributeImpl.EMPTY_ATTRIBUTE;
        R776_is_a_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R790_filters_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R796_has_condition_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    public static Where create( Sql context ) throws XtumlException {
        Where newWhere = new WhereImpl( context );
        if ( context.addInstance( newWhere ) ) {
            newWhere.getRunContext().addChange(new InstanceCreatedDelta(newWhere, KEY_LETTERS));
            return newWhere;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Where create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_base_expression_number, String ref_where_expression_number, String m_multiplicity, SortType m_sorted, String m_cast, String ref_attr_name, String ref_attr_class_package, String ref_attr_class_name ) throws XtumlException {
        Where newWhere = new WhereImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_expression_number, ref_base_expression_number, ref_where_expression_number, m_multiplicity, m_sorted, m_cast, ref_attr_name, ref_attr_class_package, ref_attr_class_name );
        if ( context.addInstance( newWhere ) ) {
            return newWhere;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
                return ref_parent_name;
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_parent_name, this.ref_parent_name ) ) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    private String ref_parent_package;
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
                return ref_parent_package;
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_parent_package, this.ref_parent_package ) ) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    private String ref_body_name;
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_body_name, this.ref_body_name ) ) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
                return ref_body_name;
    }
    private String ref_block_number;
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_block_number, this.ref_block_number ) ) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
                return ref_block_number;
    }
    private String ref_statement_number;
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
                return ref_statement_number;
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_statement_number, this.ref_statement_number ) ) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    private String ref_expression_number;
    @Override
    public String getExpression_number() throws XtumlException {
        checkLiving();
                return ref_expression_number;
    }
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_expression_number, this.ref_expression_number ) ) {
            final String oldValue = this.ref_expression_number;
            this.ref_expression_number = ref_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_expression_number", oldValue, this.ref_expression_number));
        }
    }
    private String ref_base_expression_number;
    @Override
    public String getBase_expression_number() throws XtumlException {
        checkLiving();
                return ref_base_expression_number;
    }
    @Override
    public void setBase_expression_number( String ref_base_expression_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_base_expression_number, this.ref_base_expression_number ) ) {
            final String oldValue = this.ref_base_expression_number;
            this.ref_base_expression_number = ref_base_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_base_expression_number", oldValue, this.ref_base_expression_number));
        }
    }
    private String ref_where_expression_number;
    @Override
    public String getWhere_expression_number() throws XtumlException {
        checkLiving();
                return ref_where_expression_number;
    }
    @Override
    public void setWhere_expression_number( String ref_where_expression_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_where_expression_number, this.ref_where_expression_number ) ) {
            final String oldValue = this.ref_where_expression_number;
            this.ref_where_expression_number = ref_where_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_where_expression_number", oldValue, this.ref_where_expression_number));
        }
    }
    private String m_multiplicity;
    @Override
    public void setMultiplicity( String m_multiplicity ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_multiplicity, this.m_multiplicity ) ) {
            final String oldValue = this.m_multiplicity;
            this.m_multiplicity = m_multiplicity;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_multiplicity", oldValue, this.m_multiplicity));
        }
    }
    @Override
    public String getMultiplicity() throws XtumlException {
        checkLiving();
                return m_multiplicity;
    }
    private SortType m_sorted;
    @Override
    public void setSorted( SortType m_sorted ) throws XtumlException {
        checkLiving();
        if ( m_sorted.inequality( this.m_sorted ) ) {
            final SortType oldValue = this.m_sorted;
            this.m_sorted = m_sorted;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_sorted", oldValue, this.m_sorted));
        }
    }
    @Override
    public SortType getSorted() throws XtumlException {
        checkLiving();
                return m_sorted;
    }
    private String m_cast;
    @Override
    public void setCast( String m_cast ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_cast, this.m_cast ) ) {
            final String oldValue = this.m_cast;
            this.m_cast = m_cast;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_cast", oldValue, this.m_cast));
        }
    }
    @Override
    public String getCast() throws XtumlException {
        checkLiving();
                return m_cast;
    }
    private String ref_attr_name;
    @Override
    public String getAttr_name() throws XtumlException {
        checkLiving();
                return ref_attr_name;
    }
    @Override
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_attr_name, this.ref_attr_name ) ) {
            final String oldValue = this.ref_attr_name;
            this.ref_attr_name = ref_attr_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_attr_name", oldValue, this.ref_attr_name));
        }
    }
    private String ref_attr_class_package;
    @Override
    public String getAttr_class_package() throws XtumlException {
        checkLiving();
                return ref_attr_class_package;
    }
    @Override
    public void setAttr_class_package( String ref_attr_class_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_attr_class_package, this.ref_attr_class_package ) ) {
            final String oldValue = this.ref_attr_class_package;
            this.ref_attr_class_package = ref_attr_class_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_attr_class_package", oldValue, this.ref_attr_class_package));
        }
    }
    private String ref_attr_class_name;
    @Override
    public String getAttr_class_name() throws XtumlException {
        checkLiving();
                return ref_attr_class_name;
    }
    @Override
    public void setAttr_class_name( String ref_attr_class_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_attr_class_name, this.ref_attr_class_name ) ) {
            final String oldValue = this.ref_attr_class_name;
            this.ref_attr_class_name = ref_attr_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_attr_class_name", oldValue, this.ref_attr_class_name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number(), getExpression_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        boolean sorted = self().getSorted().inequality( SortType.NONE );
        boolean sort_descending = self().getSorted().equality( SortType.DESCENDING );
        boolean use_util = false;
        String util_name = "";
        String accessor = "";
        if ( sorted ) {
            Type sort_attr_type = self().R3906_sorts_set_by_Attribute().R424_is_typed_by_TypeReference().R3800_based_on_Type();
            use_util = sort_attr_type.primitive();
            if ( StringUtil.equality( "boolean", sort_attr_type.getName() ) ) {
                util_name = "BooleanUtil";
            }
            else if ( StringUtil.equality( "int", sort_attr_type.getName() ) ) {
                util_name = "IntegerUtil";
            }
            else if ( StringUtil.equality( "double", sort_attr_type.getName() ) ) {
                util_name = "RealUtil";
            }
            AttributeAccessor attr_accessor = self().R3906_sorts_set_by_Attribute().R4510_value_accessed_through_AttributeAccessor().anyWhere(selected -> selected.getAccessor_type().equality( AttributeAccessorType.GETTER ));
            accessor = attr_accessor.getName();
        }
        Expression base_expression = self().R790_filters_Expression();
        base_expression.render();
        String root_expression_body = context().T().body();
        context().T().clear();
        Expression where_expression = self().R796_has_condition_Expression();
        where_expression.render();
        String where_expression_body = context().T().body();
        context().T().pop_buffer();
        context().T().include( "expression/t.where.java", accessor, root_expression_body, self(), sort_descending, sorted, use_util, util_name, where_expression_body );
    }



    // static operations


    // events


    // selections
    private Attribute R3906_sorts_set_by_Attribute_inst;
    @Override
    public void setR3906_sorts_set_by_Attribute( Attribute inst ) {
        R3906_sorts_set_by_Attribute_inst = inst;
    }
    @Override
    public Attribute R3906_sorts_set_by_Attribute() throws XtumlException {
        return R3906_sorts_set_by_Attribute_inst;
    }
    private Expression R776_is_a_Expression_inst;
    @Override
    public void setR776_is_a_Expression( Expression inst ) {
        R776_is_a_Expression_inst = inst;
    }
    @Override
    public Expression R776_is_a_Expression() throws XtumlException {
        return R776_is_a_Expression_inst;
    }
    private Expression R790_filters_Expression_inst;
    @Override
    public void setR790_filters_Expression( Expression inst ) {
        R790_filters_Expression_inst = inst;
    }
    @Override
    public Expression R790_filters_Expression() throws XtumlException {
        return R790_filters_Expression_inst;
    }
    private Expression R796_has_condition_Expression_inst;
    @Override
    public void setR796_has_condition_Expression( Expression inst ) {
        R796_has_condition_Expression_inst = inst;
    }
    @Override
    public Expression R796_has_condition_Expression() throws XtumlException {
        return R796_has_condition_Expression_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Where value() {
        return this;
    }

    @Override
    public Where self() {
        return this;
    }

    @Override
    public Where oneWhere( IWhere<Where> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_WHERE;
    }

}

class EmptyWhere extends ModelInstance<Where,Sql> implements Where {

    // attributes
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getExpression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBase_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBase_expression_number( String ref_base_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getWhere_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setWhere_expression_number( String ref_where_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setMultiplicity( String m_multiplicity ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getMultiplicity() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSorted( SortType m_sorted ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public SortType getSorted() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setCast( String m_cast ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getCast() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getAttr_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAttr_class_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_class_package( String ref_attr_class_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAttr_class_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_class_name( String ref_attr_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Attribute R3906_sorts_set_by_Attribute() {
        return AttributeImpl.EMPTY_ATTRIBUTE;
    }
    @Override
    public Expression R776_is_a_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }
    @Override
    public Expression R790_filters_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }
    @Override
    public Expression R796_has_condition_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }


    @Override
    public String getKeyLetters() {
        return WhereImpl.KEY_LETTERS;
    }

    @Override
    public Where value() {
        return this;
    }
    
    @Override
    public Where self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Where oneWhere( IWhere<Where> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return WhereImpl.EMPTY_WHERE;
    }

}
