package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.Selected;
import io.ciera.tool.sql.architecture.expression.SelectedSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class SelectedSetImpl extends InstanceSet<SelectedSet,Selected> implements SelectedSet {

    public SelectedSetImpl() {
    }

    public SelectedSetImpl(Comparator<? super Selected> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( Selected selected : this ) selected.setExpression_number( ref_expression_number );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( Selected selected : this ) selected.setParent_package( ref_parent_package );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( Selected selected : this ) selected.setBlock_number( ref_block_number );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( Selected selected : this ) selected.setParent_name( ref_parent_name );
    }
    @Override
    public void setCast( String m_cast ) throws XtumlException {
        for ( Selected selected : this ) selected.setCast( m_cast );
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( Selected selected : this ) selected.setName( ref_name );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( Selected selected : this ) selected.setStatement_number( ref_statement_number );
    }


    // selections
    @Override
    public ExpressionSet R776_is_a_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( Selected selected : this ) expressionset.add( selected.R776_is_a_Expression() );
        return expressionset;
    }


    @Override
    public Selected nullElement() {
        return SelectedImpl.EMPTY_SELECTED;
    }

    @Override
    public SelectedSet emptySet() {
      return new SelectedSetImpl();
    }

    @Override
    public SelectedSet emptySet(Comparator<? super Selected> comp) {
      return new SelectedSetImpl(comp);
    }

    @Override
    public SelectedSet value() {
        return this;
    }

    @Override
    public List<Selected> elements() {
        Selected[] elements = toArray(new Selected[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
