package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.expression.ActualParameter;
import io.ciera.tool.sql.architecture.expression.ActualParameterSet;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.Invocation;
import io.ciera.tool.sql.architecture.expression.impl.ActualParameterSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionImpl;
import io.ciera.tool.sql.architecture.invocable.InvocableObject;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectImpl;
import io.ciera.tool.sql.architecture.statemachine.Event;


public class InvocationImpl extends ModelInstance<Invocation,Sql> implements Invocation {

    public static final String KEY_LETTERS = "Invocation";
    public static final Invocation EMPTY_INVOCATION = new EmptyInvocation();

    private Sql context;

    // constructors
    private InvocationImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_expression_number = "";
        ref_invoked_parent_name = "";
        ref_invoked_parent_package = "";
        ref_invoked_name = "";
        ref_base_expression_number = "";
        R776_is_a_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R792_invokes_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R793_ActualParameter_set = new ActualParameterSetImpl();
        R798_invokes_activity_on_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    private InvocationImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_invoked_parent_name, String ref_invoked_parent_package, String ref_invoked_name, String ref_base_expression_number ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_expression_number = ref_expression_number;
        this.ref_invoked_parent_name = ref_invoked_parent_name;
        this.ref_invoked_parent_package = ref_invoked_parent_package;
        this.ref_invoked_name = ref_invoked_name;
        this.ref_base_expression_number = ref_base_expression_number;
        R776_is_a_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
        R792_invokes_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R793_ActualParameter_set = new ActualParameterSetImpl();
        R798_invokes_activity_on_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    public static Invocation create( Sql context ) throws XtumlException {
        Invocation newInvocation = new InvocationImpl( context );
        if ( context.addInstance( newInvocation ) ) {
            newInvocation.getRunContext().addChange(new InstanceCreatedDelta(newInvocation, KEY_LETTERS));
            return newInvocation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Invocation create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_invoked_parent_name, String ref_invoked_parent_package, String ref_invoked_name, String ref_base_expression_number ) throws XtumlException {
        Invocation newInvocation = new InvocationImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_expression_number, ref_invoked_parent_name, ref_invoked_parent_package, ref_invoked_name, ref_base_expression_number );
        if ( context.addInstance( newInvocation ) ) {
            return newInvocation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_parent_name, this.ref_parent_name ) ) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
            if ( !R793_ActualParameter().isEmpty() ) R793_ActualParameter().setParent_name( ref_parent_name );
        }
    }
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
                return ref_parent_name;
    }
    private String ref_parent_package;
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
                return ref_parent_package;
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_parent_package, this.ref_parent_package ) ) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
            if ( !R793_ActualParameter().isEmpty() ) R793_ActualParameter().setParent_package( ref_parent_package );
        }
    }
    private String ref_body_name;
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_body_name, this.ref_body_name ) ) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
            if ( !R793_ActualParameter().isEmpty() ) R793_ActualParameter().setBody_name( ref_body_name );
        }
    }
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
                return ref_body_name;
    }
    private String ref_block_number;
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_block_number, this.ref_block_number ) ) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
            if ( !R793_ActualParameter().isEmpty() ) R793_ActualParameter().setBlock_number( ref_block_number );
        }
    }
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
                return ref_block_number;
    }
    private String ref_statement_number;
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
                return ref_statement_number;
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_statement_number, this.ref_statement_number ) ) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
            if ( !R793_ActualParameter().isEmpty() ) R793_ActualParameter().setStatement_number( ref_statement_number );
        }
    }
    private String ref_expression_number;
    @Override
    public String getExpression_number() throws XtumlException {
        checkLiving();
                return ref_expression_number;
    }
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_expression_number, this.ref_expression_number ) ) {
            final String oldValue = this.ref_expression_number;
            this.ref_expression_number = ref_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_expression_number", oldValue, this.ref_expression_number));
            if ( !R793_ActualParameter().isEmpty() ) R793_ActualParameter().setInvocation_expression_number( ref_expression_number );
        }
    }
    private String ref_invoked_parent_name;
    @Override
    public String getInvoked_parent_name() throws XtumlException {
        checkLiving();
                return ref_invoked_parent_name;
    }
    @Override
    public void setInvoked_parent_name( String ref_invoked_parent_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_invoked_parent_name, this.ref_invoked_parent_name ) ) {
            final String oldValue = this.ref_invoked_parent_name;
            this.ref_invoked_parent_name = ref_invoked_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_invoked_parent_name", oldValue, this.ref_invoked_parent_name));
        }
    }
    private String ref_invoked_parent_package;
    @Override
    public void setInvoked_parent_package( String ref_invoked_parent_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_invoked_parent_package, this.ref_invoked_parent_package ) ) {
            final String oldValue = this.ref_invoked_parent_package;
            this.ref_invoked_parent_package = ref_invoked_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_invoked_parent_package", oldValue, this.ref_invoked_parent_package));
        }
    }
    @Override
    public String getInvoked_parent_package() throws XtumlException {
        checkLiving();
                return ref_invoked_parent_package;
    }
    private String ref_invoked_name;
    @Override
    public void setInvoked_name( String ref_invoked_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_invoked_name, this.ref_invoked_name ) ) {
            final String oldValue = this.ref_invoked_name;
            this.ref_invoked_name = ref_invoked_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_invoked_name", oldValue, this.ref_invoked_name));
        }
    }
    @Override
    public String getInvoked_name() throws XtumlException {
        checkLiving();
                return ref_invoked_name;
    }
    private String ref_base_expression_number;
    @Override
    public void setBase_expression_number( String ref_base_expression_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_base_expression_number, this.ref_base_expression_number ) ) {
            final String oldValue = this.ref_base_expression_number;
            this.ref_base_expression_number = ref_base_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_base_expression_number", oldValue, this.ref_base_expression_number));
        }
    }
    @Override
    public String getBase_expression_number() throws XtumlException {
        checkLiving();
                return ref_base_expression_number;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number(), getExpression_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }
    @Override
    public IInstanceIdentifier getId2() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number(), getExpression_number(), getInvoked_parent_name(), getInvoked_parent_package(), getInvoked_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        Expression base_expr = self().R798_invokes_activity_on_Expression();
        base_expr.render();
        String base_name = context().T().body();
        context().T().clear();
        String parameter_list = "";
        String sep = " ";
        ActualParameter parm = self().R793_ActualParameter().any();
        ActualParameter prev_parm = parm.R3905_follows_ActualParameter();
        while ( !prev_parm.isEmpty() ) {
            parm = prev_parm;
            prev_parm = parm.R3905_follows_ActualParameter();
        }
        while ( !parm.isEmpty() ) {
            parm.render();
            parameter_list = ( parameter_list + sep ) + context().T().body();
            sep = ", ";
            context().T().clear();
            parm = parm.R3905_precedes_ActualParameter();
        }
        if ( StringUtil.inequality( "", parameter_list ) ) {
            parameter_list = parameter_list + " ";
        }
        Event evt = self().R792_invokes_InvocableObject().R427_is_a_Event();
        boolean is_event_creation = !evt.isEmpty();
        context().T().pop_buffer();
        context().T().include( "expression/t.invocation.java", base_name, is_event_creation, parameter_list, self() );
    }



    // static operations


    // events


    // selections
    private Expression R776_is_a_Expression_inst;
    @Override
    public void setR776_is_a_Expression( Expression inst ) {
        R776_is_a_Expression_inst = inst;
    }
    @Override
    public Expression R776_is_a_Expression() throws XtumlException {
        return R776_is_a_Expression_inst;
    }
    private InvocableObject R792_invokes_InvocableObject_inst;
    @Override
    public void setR792_invokes_InvocableObject( InvocableObject inst ) {
        R792_invokes_InvocableObject_inst = inst;
    }
    @Override
    public InvocableObject R792_invokes_InvocableObject() throws XtumlException {
        return R792_invokes_InvocableObject_inst;
    }
    private ActualParameterSet R793_ActualParameter_set;
    @Override
    public void addR793_ActualParameter( ActualParameter inst ) {
        R793_ActualParameter_set.add(inst);
    }
    @Override
    public void removeR793_ActualParameter( ActualParameter inst ) {
        R793_ActualParameter_set.remove(inst);
    }
    @Override
    public ActualParameterSet R793_ActualParameter() throws XtumlException {
        return R793_ActualParameter_set;
    }
    private Expression R798_invokes_activity_on_Expression_inst;
    @Override
    public void setR798_invokes_activity_on_Expression( Expression inst ) {
        R798_invokes_activity_on_Expression_inst = inst;
    }
    @Override
    public Expression R798_invokes_activity_on_Expression() throws XtumlException {
        return R798_invokes_activity_on_Expression_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Invocation value() {
        return this;
    }

    @Override
    public Invocation self() {
        return this;
    }

    @Override
    public Invocation oneWhere( IWhere<Invocation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_INVOCATION;
    }

}

class EmptyInvocation extends ModelInstance<Invocation,Sql> implements Invocation {

    // attributes
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getExpression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getInvoked_parent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInvoked_parent_name( String ref_invoked_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setInvoked_parent_package( String ref_invoked_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getInvoked_parent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInvoked_name( String ref_invoked_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getInvoked_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBase_expression_number( String ref_base_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBase_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Expression R776_is_a_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }
    @Override
    public InvocableObject R792_invokes_InvocableObject() {
        return InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
    }
    @Override
    public ActualParameterSet R793_ActualParameter() {
        return (new ActualParameterSetImpl());
    }
    @Override
    public Expression R798_invokes_activity_on_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }


    @Override
    public String getKeyLetters() {
        return InvocationImpl.KEY_LETTERS;
    }

    @Override
    public Invocation value() {
        return this;
    }
    
    @Override
    public Invocation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Invocation oneWhere( IWhere<Invocation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return InvocationImpl.EMPTY_INVOCATION;
    }

}
