package io.ciera.tool.sql.architecture.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.component.CardinalityCheck;


public class CardinalityCheckImpl extends ModelInstance<CardinalityCheck,Sql> implements CardinalityCheck {

    public static final String KEY_LETTERS = "CardinalityCheck";
    public static final CardinalityCheck EMPTY_CARDINALITYCHECK = new EmptyCardinalityCheck();

    private Sql context;

    // constructors
    private CardinalityCheckImpl( Sql context ) {
        this.context = context;
        m_participant = "";
        m_relationship_set_cast = "";
    }

    private CardinalityCheckImpl( Sql context, UniqueId instanceId, String m_participant, String m_relationship_set_cast ) {
        super(instanceId);
        this.context = context;
        this.m_participant = m_participant;
        this.m_relationship_set_cast = m_relationship_set_cast;
    }

    public static CardinalityCheck create( Sql context ) throws XtumlException {
        CardinalityCheck newCardinalityCheck = new CardinalityCheckImpl( context );
        if ( context.addInstance( newCardinalityCheck ) ) {
            newCardinalityCheck.getRunContext().addChange(new InstanceCreatedDelta(newCardinalityCheck, KEY_LETTERS));
            return newCardinalityCheck;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static CardinalityCheck create( Sql context, UniqueId instanceId, String m_participant, String m_relationship_set_cast ) throws XtumlException {
        CardinalityCheck newCardinalityCheck = new CardinalityCheckImpl( context, instanceId, m_participant, m_relationship_set_cast );
        if ( context.addInstance( newCardinalityCheck ) ) {
            return newCardinalityCheck;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String m_participant;
    @Override
    public void setParticipant( String m_participant ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_participant, this.m_participant ) ) {
            final String oldValue = this.m_participant;
            this.m_participant = m_participant;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_participant", oldValue, this.m_participant));
        }
    }
    @Override
    public String getParticipant() throws XtumlException {
        checkLiving();
                return m_participant;
    }
    private String m_relationship_set_cast;
    @Override
    public String getRelationship_set_cast() throws XtumlException {
        checkLiving();
                return m_relationship_set_cast;
    }
    @Override
    public void setRelationship_set_cast( String m_relationship_set_cast ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_relationship_set_cast, this.m_relationship_set_cast ) ) {
            final String oldValue = this.m_relationship_set_cast;
            this.m_relationship_set_cast = m_relationship_set_cast;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_relationship_set_cast", oldValue, this.m_relationship_set_cast));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParticipant());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
    }



    // static operations


    // events


    // selections


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public CardinalityCheck value() {
        return this;
    }

    @Override
    public CardinalityCheck self() {
        return this;
    }

    @Override
    public CardinalityCheck oneWhere( IWhere<CardinalityCheck> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_CARDINALITYCHECK;
    }

}

class EmptyCardinalityCheck extends ModelInstance<CardinalityCheck,Sql> implements CardinalityCheck {

    // attributes
    public void setParticipant( String m_participant ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParticipant() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getRelationship_set_cast() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRelationship_set_cast( String m_relationship_set_cast ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections


    @Override
    public String getKeyLetters() {
        return CardinalityCheckImpl.KEY_LETTERS;
    }

    @Override
    public CardinalityCheck value() {
        return this;
    }
    
    @Override
    public CardinalityCheck self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public CardinalityCheck oneWhere( IWhere<CardinalityCheck> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return CardinalityCheckImpl.EMPTY_CARDINALITYCHECK;
    }

}
