package io.ciera.tool.sql.architecture.component;


import io.ciera.runtime.summit.classes.IModelInstance;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.application.ComponentInstantiation;
import io.ciera.tool.sql.architecture.application.ComponentInstantiationSet;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.ModelInstSet;
import io.ciera.tool.sql.architecture.component.Function;
import io.ciera.tool.sql.architecture.component.FunctionSet;
import io.ciera.tool.sql.architecture.component.InstancePopulationSelector;
import io.ciera.tool.sql.architecture.component.InstancePopulationSelectorSet;
import io.ciera.tool.sql.architecture.component.RelationshipPopulationSelector;
import io.ciera.tool.sql.architecture.component.RelationshipPopulationSelectorSet;
import io.ciera.tool.sql.architecture.component.UtilityReference;
import io.ciera.tool.sql.architecture.component.UtilityReferenceSet;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.interfaces.Port;
import io.ciera.tool.sql.architecture.interfaces.PortSet;
import io.ciera.tool.sql.architecture.relationship.ClassRelationship;
import io.ciera.tool.sql.architecture.relationship.ClassRelationshipSet;
import io.ciera.tool.sql.ooaofooa.component.C_C;


public interface ComponentDefinition extends IModelInstance<ComponentDefinition,Sql> {

    // attributes
    public String getName() throws XtumlException;
    public void setName( String ref_name ) throws XtumlException;
    public void setPackage( String ref_package ) throws XtumlException;
    public String getPackage() throws XtumlException;
    public String getInit_function_name() throws XtumlException;
    public void setInit_function_name( String ref_init_function_name ) throws XtumlException;
    public void setExtends( String m_extends ) throws XtumlException;
    public String getExtends() throws XtumlException;
    public void setC_c_Id( UniqueId ref_c_c_Id ) throws XtumlException;
    public UniqueId getC_c_Id() throws XtumlException;
    public String getVersion() throws XtumlException;
    public void setVersion( String m_version ) throws XtumlException;
    public String getVersion_date() throws XtumlException;
    public void setVersion_date( String m_version_date ) throws XtumlException;


    // operations
    public void render() throws XtumlException;
    public void render_version() throws XtumlException;


    // selections
    default public void setR401_is_a_File( File inst ) {}
    public File R401_is_a_File() throws XtumlException;
    default public void addR405_provides_synchronous_Function( Function inst ) {}
    default public void removeR405_provides_synchronous_Function( Function inst ) {}
    public FunctionSet R405_provides_synchronous_Function() throws XtumlException;
    default public void addR408_maintains_instances_of_ModelInst( ModelInst inst ) {}
    default public void removeR408_maintains_instances_of_ModelInst( ModelInst inst ) {}
    public ModelInstSet R408_maintains_instances_of_ModelInst() throws XtumlException;
    default public void addR417_communicates_through_Port( Port inst ) {}
    default public void removeR417_communicates_through_Port( Port inst ) {}
    public PortSet R417_communicates_through_Port() throws XtumlException;
    default public void addR426_is_instantiated_by_ComponentInstantiation( ComponentInstantiation inst ) {}
    default public void removeR426_is_instantiated_by_ComponentInstantiation( ComponentInstantiation inst ) {}
    public ComponentInstantiationSet R426_is_instantiated_by_ComponentInstantiation() throws XtumlException;
    default public void addR447_selects_instances_through_InstancePopulationSelector( InstancePopulationSelector inst ) {}
    default public void removeR447_selects_instances_through_InstancePopulationSelector( InstancePopulationSelector inst ) {}
    public InstancePopulationSelectorSet R447_selects_instances_through_InstancePopulationSelector() throws XtumlException;
    default public void addR448_maintains_instances_of_ClassRelationship( ClassRelationship inst ) {}
    default public void removeR448_maintains_instances_of_ClassRelationship( ClassRelationship inst ) {}
    public ClassRelationshipSet R448_maintains_instances_of_ClassRelationship() throws XtumlException;
    default public void addR4558_contains_UtilityReference( UtilityReference inst ) {}
    default public void removeR4558_contains_UtilityReference( UtilityReference inst ) {}
    public UtilityReferenceSet R4558_contains_UtilityReference() throws XtumlException;
    default public void setR4561_initialized_by_Function( Function inst ) {}
    public Function R4561_initialized_by_Function() throws XtumlException;
    default public void addR4571_selects_relationships_through_RelationshipPopulationSelector( RelationshipPopulationSelector inst ) {}
    default public void removeR4571_selects_relationships_through_RelationshipPopulationSelector( RelationshipPopulationSelector inst ) {}
    public RelationshipPopulationSelectorSet R4571_selects_relationships_through_RelationshipPopulationSelector() throws XtumlException;
    default public void setR4573_is_transformed_from_C_C( C_C inst ) {}
    public C_C R4573_is_transformed_from_C_C() throws XtumlException;


}
