package types;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum SortType implements IXtumlType<SortType> {

    UNINITIALIZED_ENUM( -1 ),
    ASCENDING( 1 ),
    DESCENDING( 2 ),
    NONE( 0 );

    private final int value;

    SortType() {
        value = -1;
    }

    SortType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( SortType value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public SortType value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static SortType deserialize(Object o) throws XtumlException {
        if (o instanceof SortType) {
            return (SortType)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static SortType valueOf(int value) {
        switch( value ) {
        case 1:
            return ASCENDING;
        case 2:
            return DESCENDING;
        case 0:
            return NONE;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
