package types;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum Mult implements IXtumlType<Mult> {

    UNINITIALIZED_ENUM( -1 ),
    MANY( 1 ),
    ONE( 0 );

    private final int value;

    Mult() {
        value = -1;
    }

    Mult( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( Mult value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public Mult value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static Mult deserialize(Object o) throws XtumlException {
        if (o instanceof Mult) {
            return (Mult)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static Mult valueOf(int value) {
        switch( value ) {
        case 1:
            return MANY;
        case 0:
            return ONE;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
