package types;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum ImportType implements IXtumlType<ImportType> {

    UNINITIALIZED_ENUM( -1 ),
    BOTH( 2 ),
    IMPL( 0 ),
    INT( 1 );

    private final int value;

    ImportType() {
        value = -1;
    }

    ImportType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( ImportType value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public ImportType value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static ImportType deserialize(Object o) throws XtumlException {
        if (o instanceof ImportType) {
            return (ImportType)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static ImportType valueOf(int value) {
        switch( value ) {
        case 2:
            return BOTH;
        case 0:
            return IMPL;
        case 1:
            return INT;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
