package types;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum Cond implements IXtumlType<Cond> {

    UNINITIALIZED_ENUM( -1 ),
    CONDITIONAL( 1 ),
    UNCONDITIONAL( 0 );

    private final int value;

    Cond() {
        value = -1;
    }

    Cond( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( Cond value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public Cond value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static Cond deserialize(Object o) throws XtumlException {
        if (o instanceof Cond) {
            return (Cond)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static Cond valueOf(int value) {
        switch( value ) {
        case 1:
            return CONDITIONAL;
        case 0:
            return UNCONDITIONAL;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
