package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum StateEnum implements IXtumlType<StateEnum> {

    UNINITIALIZED_ENUM( -1 ),
    DISABLED( 0 ),
    ENABLED( 1 );

    private final int value;

    StateEnum() {
        value = -1;
    }

    StateEnum( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( StateEnum value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public StateEnum value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static StateEnum deserialize(Object o) throws XtumlException {
        if (o instanceof StateEnum) {
            return (StateEnum)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static StateEnum valueOf(int value) {
        switch( value ) {
        case 0:
            return DISABLED;
        case 1:
            return ENABLED;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
