package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum SearchScope implements IXtumlType<SearchScope> {

    UNINITIALIZED_ENUM( -1 ),
    ENCLOSINGSYSTEM( 0 ),
    SELECTION( 2 ),
    UNIVERSE( 1 );

    private final int value;

    SearchScope() {
        value = -1;
    }

    SearchScope( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( SearchScope value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public SearchScope value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static SearchScope deserialize(Object o) throws XtumlException {
        if (o instanceof SearchScope) {
            return (SearchScope)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static SearchScope valueOf(int value) {
        switch( value ) {
        case 0:
            return ENCLOSINGSYSTEM;
        case 2:
            return SELECTION;
        case 1:
            return UNIVERSE;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
