package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum RunStateType implements IXtumlType<RunStateType> {

    UNINITIALIZED_ENUM( -1 ),
    RUNNING( 0 ),
    STEPPING( 1 ),
    SUSPENDED( 2 ),
    TERMINATED( 3 );

    private final int value;

    RunStateType() {
        value = -1;
    }

    RunStateType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( RunStateType value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public RunStateType value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static RunStateType deserialize(Object o) throws XtumlException {
        if (o instanceof RunStateType) {
            return (RunStateType)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static RunStateType valueOf(int value) {
        switch( value ) {
        case 0:
            return RUNNING;
        case 1:
            return STEPPING;
        case 2:
            return SUSPENDED;
        case 3:
            return TERMINATED;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
