package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum ParseStatus implements IXtumlType<ParseStatus> {

    UNINITIALIZED_ENUM( -1 ),
    DONOTPARSE( 0 ),
    PARSEINITIAL( 1 ),
    PARSESUCCESSFUL( 2 ),
    PARSEUNSUCCESSFUL( 3 );

    private final int value;

    ParseStatus() {
        value = -1;
    }

    ParseStatus( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( ParseStatus value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public ParseStatus value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static ParseStatus deserialize(Object o) throws XtumlException {
        if (o instanceof ParseStatus) {
            return (ParseStatus)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static ParseStatus valueOf(int value) {
        switch( value ) {
        case 0:
            return DONOTPARSE;
        case 1:
            return PARSEINITIAL;
        case 2:
            return PARSESUCCESSFUL;
        case 3:
            return PARSEUNSUCCESSFUL;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
