package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum OalConstants implements IXtumlType<OalConstants> {

    UNINITIALIZED_ENUM( -1 ),
    BRIDGE_TYPE( 0 ),
    FUNCTION_TYPE( 1 ),
    IB_OPERATION_TYPE( 2 ),
    MDA_TYPE( 3 ),
    OPERATION_TYPE( 4 ),
    PROV_OPERATION_TYPE( 5 ),
    PROV_SIGNAL_TYPE( 6 ),
    REQ_OPERATION_TYPE( 7 ),
    REQ_SIGNAL_TYPE( 8 ),
    STATE_TYPE( 9 ),
    TRANSITION_TYPE( 10 );

    private final int value;

    OalConstants() {
        value = -1;
    }

    OalConstants( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( OalConstants value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public OalConstants value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static OalConstants deserialize(Object o) throws XtumlException {
        if (o instanceof OalConstants) {
            return (OalConstants)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static OalConstants valueOf(int value) {
        switch( value ) {
        case 0:
            return BRIDGE_TYPE;
        case 1:
            return FUNCTION_TYPE;
        case 2:
            return IB_OPERATION_TYPE;
        case 3:
            return MDA_TYPE;
        case 4:
            return OPERATION_TYPE;
        case 5:
            return PROV_OPERATION_TYPE;
        case 6:
            return PROV_SIGNAL_TYPE;
        case 7:
            return REQ_OPERATION_TYPE;
        case 8:
            return REQ_SIGNAL_TYPE;
        case 9:
            return STATE_TYPE;
        case 10:
            return TRANSITION_TYPE;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
