package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum Multiplicity implements IXtumlType<Multiplicity> {

    UNINITIALIZED_ENUM( -1 ),
    MANY( 0 ),
    ONE( 1 ),
    UNKNOWN( 2 );

    private final int value;

    Multiplicity() {
        value = -1;
    }

    Multiplicity( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( Multiplicity value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public Multiplicity value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static Multiplicity deserialize(Object o) throws XtumlException {
        if (o instanceof Multiplicity) {
            return (Multiplicity)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static Multiplicity valueOf(int value) {
        switch( value ) {
        case 0:
            return MANY;
        case 1:
            return ONE;
        case 2:
            return UNKNOWN;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
