package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum Justification implements IXtumlType<Justification> {

    UNINITIALIZED_ENUM( -1 ),
    BOTTOM( 0 ),
    CENTER( 1 ),
    CENTER_IN_X( 2 ),
    FLOATING( 3 ),
    LEFT( 4 ),
    RIGHT( 5 );

    private final int value;

    Justification() {
        value = -1;
    }

    Justification( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( Justification value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public Justification value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static Justification deserialize(Object o) throws XtumlException {
        if (o instanceof Justification) {
            return (Justification)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static Justification valueOf(int value) {
        switch( value ) {
        case 0:
            return BOTTOM;
        case 1:
            return CENTER;
        case 2:
            return CENTER_IN_X;
        case 3:
            return FLOATING;
        case 4:
            return LEFT;
        case 5:
            return RIGHT;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
