package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum ImplementationScope implements IXtumlType<ImplementationScope> {

    UNINITIALIZED_ENUM( -1 ),
    DEPLOYMENT( 1 ),
    DOMAIN( 0 );

    private final int value;

    ImplementationScope() {
        value = -1;
    }

    ImplementationScope( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( ImplementationScope value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public ImplementationScope value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static ImplementationScope deserialize(Object o) throws XtumlException {
        if (o instanceof ImplementationScope) {
            return (ImplementationScope)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static ImplementationScope valueOf(int value) {
        switch( value ) {
        case 1:
            return DEPLOYMENT;
        case 0:
            return DOMAIN;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
