package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum IFDirectionType implements IXtumlType<IFDirectionType> {

    UNINITIALIZED_ENUM( -1 ),
    CLIENTSERVER( 0 ),
    SERVERCLIENT( 1 );

    private final int value;

    IFDirectionType() {
        value = -1;
    }

    IFDirectionType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IFDirectionType value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public IFDirectionType value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static IFDirectionType deserialize(Object o) throws XtumlException {
        if (o instanceof IFDirectionType) {
            return (IFDirectionType)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static IFDirectionType valueOf(int value) {
        switch( value ) {
        case 0:
            return CLIENTSERVER;
        case 1:
            return SERVERCLIENT;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
