package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.value.V_VAR;
import io.ciera.tool.sql.ooaofooa.value.VariableLocation;
import io.ciera.tool.sql.ooaofooa.value.impl.V_VARImpl;


public class VariableLocationImpl extends ModelInstance<VariableLocation,Sql> implements VariableLocation {

    public static final String KEY_LETTERS = "V_LOC";
    public static final VariableLocation EMPTY_VARIABLELOCATION = new EmptyVariableLocation();

    private Sql context;

    // constructors
    private VariableLocationImpl( Sql context ) {
        this.context = context;
        m_Id = UniqueId.random();
        m_LineNumber = 0;
        m_StartPosition = 0;
        m_EndPosition = 0;
        ref_Var_ID = UniqueId.random();
        R835_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
    }

    private VariableLocationImpl( Sql context, UniqueId instanceId, UniqueId m_Id, int m_LineNumber, int m_StartPosition, int m_EndPosition, UniqueId ref_Var_ID ) {
        super(instanceId);
        this.context = context;
        this.m_Id = m_Id;
        this.m_LineNumber = m_LineNumber;
        this.m_StartPosition = m_StartPosition;
        this.m_EndPosition = m_EndPosition;
        this.ref_Var_ID = ref_Var_ID;
        R835_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
    }

    public static VariableLocation create( Sql context ) throws XtumlException {
        VariableLocation newVariableLocation = new VariableLocationImpl( context );
        if ( context.addInstance( newVariableLocation ) ) {
            newVariableLocation.getRunContext().addChange(new InstanceCreatedDelta(newVariableLocation, KEY_LETTERS));
            return newVariableLocation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static VariableLocation create( Sql context, UniqueId instanceId, UniqueId m_Id, int m_LineNumber, int m_StartPosition, int m_EndPosition, UniqueId ref_Var_ID ) throws XtumlException {
        VariableLocation newVariableLocation = new VariableLocationImpl( context, instanceId, m_Id, m_LineNumber, m_StartPosition, m_EndPosition, ref_Var_ID );
        if ( context.addInstance( newVariableLocation ) ) {
            return newVariableLocation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Id;
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
                return m_Id;
    }
    @Override
    public void setId( UniqueId m_Id ) throws XtumlException {
        checkLiving();
        if ( m_Id.inequality( this.m_Id ) ) {
            final UniqueId oldValue = this.m_Id;
            this.m_Id = m_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Id", oldValue, this.m_Id));
        }
    }
    private int m_LineNumber;
    @Override
    public int getLineNumber() throws XtumlException {
        checkLiving();
                return m_LineNumber;
    }
    @Override
    public void setLineNumber( int m_LineNumber ) throws XtumlException {
        checkLiving();
        if ( m_LineNumber != this.m_LineNumber ) {
            final int oldValue = this.m_LineNumber;
            this.m_LineNumber = m_LineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_LineNumber", oldValue, this.m_LineNumber));
        }
    }
    private int m_StartPosition;
    @Override
    public int getStartPosition() throws XtumlException {
        checkLiving();
                return m_StartPosition;
    }
    @Override
    public void setStartPosition( int m_StartPosition ) throws XtumlException {
        checkLiving();
        if ( m_StartPosition != this.m_StartPosition ) {
            final int oldValue = this.m_StartPosition;
            this.m_StartPosition = m_StartPosition;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_StartPosition", oldValue, this.m_StartPosition));
        }
    }
    private int m_EndPosition;
    @Override
    public int getEndPosition() throws XtumlException {
        checkLiving();
                return m_EndPosition;
    }
    @Override
    public void setEndPosition( int m_EndPosition ) throws XtumlException {
        checkLiving();
        if ( m_EndPosition != this.m_EndPosition ) {
            final int oldValue = this.m_EndPosition;
            this.m_EndPosition = m_EndPosition;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_EndPosition", oldValue, this.m_EndPosition));
        }
    }
    private UniqueId ref_Var_ID;
    @Override
    public void setVar_ID( UniqueId ref_Var_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Var_ID.inequality( this.ref_Var_ID ) ) {
            final UniqueId oldValue = this.ref_Var_ID;
            this.ref_Var_ID = ref_Var_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Var_ID", oldValue, this.ref_Var_ID));
        }
    }
    @Override
    public UniqueId getVar_ID() throws XtumlException {
        checkLiving();
                return ref_Var_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private V_VAR R835_V_VAR_inst;
    @Override
    public void setR835_V_VAR( V_VAR inst ) {
        R835_V_VAR_inst = inst;
    }
    @Override
    public V_VAR R835_V_VAR() throws XtumlException {
        return R835_V_VAR_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public VariableLocation value() {
        return this;
    }

    @Override
    public VariableLocation self() {
        return this;
    }

    @Override
    public VariableLocation oneWhere( IWhere<VariableLocation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_VARIABLELOCATION;
    }

}

class EmptyVariableLocation extends ModelInstance<VariableLocation,Sql> implements VariableLocation {

    // attributes
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId m_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLineNumber( int m_LineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getStartPosition() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStartPosition( int m_StartPosition ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getEndPosition() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEndPosition( int m_EndPosition ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setVar_ID( UniqueId ref_Var_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getVar_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public V_VAR R835_V_VAR() {
        return V_VARImpl.EMPTY_V_VAR;
    }


    @Override
    public String getKeyLetters() {
        return VariableLocationImpl.KEY_LETTERS;
    }

    @Override
    public VariableLocation value() {
        return this;
    }
    
    @Override
    public VariableLocation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public VariableLocation oneWhere( IWhere<VariableLocation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return VariableLocationImpl.EMPTY_VARIABLELOCATION;
    }

}
