package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.value.V_AER;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class V_AERImpl extends ModelInstance<V_AER,Sql> implements V_AER {

    public static final String KEY_LETTERS = "V_AER";
    public static final V_AER EMPTY_V_AER = new EmptyV_AER();

    private Sql context;

    // constructors
    private V_AERImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        ref_Root_Value_ID = UniqueId.random();
        ref_Index_Value_ID = UniqueId.random();
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R838_has_root_Value_inst = ValueImpl.EMPTY_VALUE;
        R839_has_index_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    private V_AERImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Root_Value_ID, UniqueId ref_Index_Value_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_Root_Value_ID = ref_Root_Value_ID;
        this.ref_Index_Value_ID = ref_Index_Value_ID;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R838_has_root_Value_inst = ValueImpl.EMPTY_VALUE;
        R839_has_index_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    public static V_AER create( Sql context ) throws XtumlException {
        V_AER newV_AER = new V_AERImpl( context );
        if ( context.addInstance( newV_AER ) ) {
            newV_AER.getRunContext().addChange(new InstanceCreatedDelta(newV_AER, KEY_LETTERS));
            return newV_AER;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static V_AER create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Root_Value_ID, UniqueId ref_Index_Value_ID ) throws XtumlException {
        V_AER newV_AER = new V_AERImpl( context, instanceId, ref_Value_ID, ref_Root_Value_ID, ref_Index_Value_ID );
        if ( context.addInstance( newV_AER ) ) {
            return newV_AER;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
                return ref_Value_ID;
    }
    @Override
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Value_ID.inequality( this.ref_Value_ID ) ) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    private UniqueId ref_Root_Value_ID;
    @Override
    public void setRoot_Value_ID( UniqueId ref_Root_Value_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Root_Value_ID.inequality( this.ref_Root_Value_ID ) ) {
            final UniqueId oldValue = this.ref_Root_Value_ID;
            this.ref_Root_Value_ID = ref_Root_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Root_Value_ID", oldValue, this.ref_Root_Value_ID));
        }
    }
    @Override
    public UniqueId getRoot_Value_ID() throws XtumlException {
        checkLiving();
                return ref_Root_Value_ID;
    }
    private UniqueId ref_Index_Value_ID;
    @Override
    public void setIndex_Value_ID( UniqueId ref_Index_Value_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Index_Value_ID.inequality( this.ref_Index_Value_ID ) ) {
            final UniqueId oldValue = this.ref_Index_Value_ID;
            this.ref_Index_Value_ID = ref_Index_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Index_Value_ID", oldValue, this.ref_Index_Value_ID));
        }
    }
    @Override
    public UniqueId getIndex_Value_ID() throws XtumlException {
        checkLiving();
                return ref_Index_Value_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R801_is_a_Value_inst;
    @Override
    public void setR801_is_a_Value( Value inst ) {
        R801_is_a_Value_inst = inst;
    }
    @Override
    public Value R801_is_a_Value() throws XtumlException {
        return R801_is_a_Value_inst;
    }
    private Value R838_has_root_Value_inst;
    @Override
    public void setR838_has_root_Value( Value inst ) {
        R838_has_root_Value_inst = inst;
    }
    @Override
    public Value R838_has_root_Value() throws XtumlException {
        return R838_has_root_Value_inst;
    }
    private Value R839_has_index_Value_inst;
    @Override
    public void setR839_has_index_Value( Value inst ) {
        R839_has_index_Value_inst = inst;
    }
    @Override
    public Value R839_has_index_Value() throws XtumlException {
        return R839_has_index_Value_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public V_AER value() {
        return this;
    }

    @Override
    public V_AER self() {
        return this;
    }

    @Override
    public V_AER oneWhere( IWhere<V_AER> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_V_AER;
    }

}

class EmptyV_AER extends ModelInstance<V_AER,Sql> implements V_AER {

    // attributes
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setRoot_Value_ID( UniqueId ref_Root_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRoot_Value_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIndex_Value_ID( UniqueId ref_Index_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getIndex_Value_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R801_is_a_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public Value R838_has_root_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public Value R839_has_index_Value() {
        return ValueImpl.EMPTY_VALUE;
    }


    @Override
    public String getKeyLetters() {
        return V_AERImpl.KEY_LETTERS;
    }

    @Override
    public V_AER value() {
        return this;
    }
    
    @Override
    public V_AER self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public V_AER oneWhere( IWhere<V_AER> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return V_AERImpl.EMPTY_V_AER;
    }

}
