package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.constants.SymbolicConstant;
import io.ciera.tool.sql.ooaofooa.constants.impl.SymbolicConstantImpl;
import io.ciera.tool.sql.ooaofooa.value.SymbolicConstantValue;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class SymbolicConstantValueImpl extends ModelInstance<SymbolicConstantValue,Sql> implements SymbolicConstantValue {

    public static final String KEY_LETTERS = "V_SCV";
    public static final SymbolicConstantValue EMPTY_SYMBOLICCONSTANTVALUE = new EmptySymbolicConstantValue();

    private Sql context;

    // constructors
    private SymbolicConstantValueImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        ref_Const_ID = UniqueId.random();
        m_DT_ID_Deprecated = UniqueId.random();
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R850_SymbolicConstant_inst = SymbolicConstantImpl.EMPTY_SYMBOLICCONSTANT;
    }

    private SymbolicConstantValueImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Const_ID, UniqueId m_DT_ID_Deprecated ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_Const_ID = ref_Const_ID;
        this.m_DT_ID_Deprecated = m_DT_ID_Deprecated;
        R801_is_a_Value_inst = ValueImpl.EMPTY_VALUE;
        R850_SymbolicConstant_inst = SymbolicConstantImpl.EMPTY_SYMBOLICCONSTANT;
    }

    public static SymbolicConstantValue create( Sql context ) throws XtumlException {
        SymbolicConstantValue newSymbolicConstantValue = new SymbolicConstantValueImpl( context );
        if ( context.addInstance( newSymbolicConstantValue ) ) {
            newSymbolicConstantValue.getRunContext().addChange(new InstanceCreatedDelta(newSymbolicConstantValue, KEY_LETTERS));
            return newSymbolicConstantValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SymbolicConstantValue create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_Const_ID, UniqueId m_DT_ID_Deprecated ) throws XtumlException {
        SymbolicConstantValue newSymbolicConstantValue = new SymbolicConstantValueImpl( context, instanceId, ref_Value_ID, ref_Const_ID, m_DT_ID_Deprecated );
        if ( context.addInstance( newSymbolicConstantValue ) ) {
            return newSymbolicConstantValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
                return ref_Value_ID;
    }
    @Override
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Value_ID.inequality( this.ref_Value_ID ) ) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    private UniqueId ref_Const_ID;
    @Override
    public UniqueId getConst_ID() throws XtumlException {
        checkLiving();
                return ref_Const_ID;
    }
    @Override
    public void setConst_ID( UniqueId ref_Const_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Const_ID.inequality( this.ref_Const_ID ) ) {
            final UniqueId oldValue = this.ref_Const_ID;
            this.ref_Const_ID = ref_Const_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Const_ID", oldValue, this.ref_Const_ID));
        }
    }
    private UniqueId m_DT_ID_Deprecated;
    @Override
    public void setDT_ID_Deprecated( UniqueId m_DT_ID_Deprecated ) throws XtumlException {
        checkLiving();
        if ( m_DT_ID_Deprecated.inequality( this.m_DT_ID_Deprecated ) ) {
            final UniqueId oldValue = this.m_DT_ID_Deprecated;
            this.m_DT_ID_Deprecated = m_DT_ID_Deprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_DT_ID_Deprecated", oldValue, this.m_DT_ID_Deprecated));
        }
    }
    @Override
    public UniqueId getDT_ID_Deprecated() throws XtumlException {
        checkLiving();
                return m_DT_ID_Deprecated;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Value R801_is_a_Value_inst;
    @Override
    public void setR801_is_a_Value( Value inst ) {
        R801_is_a_Value_inst = inst;
    }
    @Override
    public Value R801_is_a_Value() throws XtumlException {
        return R801_is_a_Value_inst;
    }
    private SymbolicConstant R850_SymbolicConstant_inst;
    @Override
    public void setR850_SymbolicConstant( SymbolicConstant inst ) {
        R850_SymbolicConstant_inst = inst;
    }
    @Override
    public SymbolicConstant R850_SymbolicConstant() throws XtumlException {
        return R850_SymbolicConstant_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SymbolicConstantValue value() {
        return this;
    }

    @Override
    public SymbolicConstantValue self() {
        return this;
    }

    @Override
    public SymbolicConstantValue oneWhere( IWhere<SymbolicConstantValue> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_SYMBOLICCONSTANTVALUE;
    }

}

class EmptySymbolicConstantValue extends ModelInstance<SymbolicConstantValue,Sql> implements SymbolicConstantValue {

    // attributes
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getConst_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setConst_ID( UniqueId ref_Const_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDT_ID_Deprecated( UniqueId m_DT_ID_Deprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_ID_Deprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Value R801_is_a_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public SymbolicConstant R850_SymbolicConstant() {
        return SymbolicConstantImpl.EMPTY_SYMBOLICCONSTANT;
    }


    @Override
    public String getKeyLetters() {
        return SymbolicConstantValueImpl.KEY_LETTERS;
    }

    @Override
    public SymbolicConstantValue value() {
        return this;
    }
    
    @Override
    public SymbolicConstantValue self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SymbolicConstantValue oneWhere( IWhere<SymbolicConstantValue> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return SymbolicConstantValueImpl.EMPTY_SYMBOLICCONSTANTVALUE;
    }

}
