package io.ciera.tool.sql.ooaofooa.subsystem.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.Association;
import io.ciera.tool.sql.ooaofooa.association.impl.AssociationImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.Deferral;
import io.ciera.tool.sql.ooaofooa.subsystem.O_TFR;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_TFRImpl;


public class DeferralImpl extends ModelInstance<Deferral,Sql> implements Deferral {

    public static final String KEY_LETTERS = "O_DEF";
    public static final Deferral EMPTY_DEFERRAL = new EmptyDeferral();

    private Sql context;

    // constructors
    private DeferralImpl( Sql context ) {
        this.context = context;
        ref_Tfr_ID = UniqueId.random();
        ref_Rel_ID = UniqueId.random();
        R126_defers_execution_to_subtypes_across_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
        R126_delegates_execution_of_O_TFR_inst = O_TFRImpl.EMPTY_O_TFR;
    }

    private DeferralImpl( Sql context, UniqueId instanceId, UniqueId ref_Tfr_ID, UniqueId ref_Rel_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Tfr_ID = ref_Tfr_ID;
        this.ref_Rel_ID = ref_Rel_ID;
        R126_defers_execution_to_subtypes_across_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
        R126_delegates_execution_of_O_TFR_inst = O_TFRImpl.EMPTY_O_TFR;
    }

    public static Deferral create( Sql context ) throws XtumlException {
        Deferral newDeferral = new DeferralImpl( context );
        if ( context.addInstance( newDeferral ) ) {
            newDeferral.getRunContext().addChange(new InstanceCreatedDelta(newDeferral, KEY_LETTERS));
            return newDeferral;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Deferral create( Sql context, UniqueId instanceId, UniqueId ref_Tfr_ID, UniqueId ref_Rel_ID ) throws XtumlException {
        Deferral newDeferral = new DeferralImpl( context, instanceId, ref_Tfr_ID, ref_Rel_ID );
        if ( context.addInstance( newDeferral ) ) {
            return newDeferral;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Tfr_ID;
    @Override
    public void setTfr_ID( UniqueId ref_Tfr_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Tfr_ID.inequality( this.ref_Tfr_ID ) ) {
            final UniqueId oldValue = this.ref_Tfr_ID;
            this.ref_Tfr_ID = ref_Tfr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Tfr_ID", oldValue, this.ref_Tfr_ID));
        }
    }
    @Override
    public UniqueId getTfr_ID() throws XtumlException {
        checkLiving();
                return ref_Tfr_ID;
    }
    private UniqueId ref_Rel_ID;
    @Override
    public UniqueId getRel_ID() throws XtumlException {
        checkLiving();
                return ref_Rel_ID;
    }
    @Override
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Rel_ID.inequality( this.ref_Rel_ID ) ) {
            final UniqueId oldValue = this.ref_Rel_ID;
            this.ref_Rel_ID = ref_Rel_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Rel_ID", oldValue, this.ref_Rel_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getTfr_ID(), getRel_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Association R126_defers_execution_to_subtypes_across_Association_inst;
    @Override
    public void setR126_defers_execution_to_subtypes_across_Association( Association inst ) {
        R126_defers_execution_to_subtypes_across_Association_inst = inst;
    }
    @Override
    public Association R126_defers_execution_to_subtypes_across_Association() throws XtumlException {
        return R126_defers_execution_to_subtypes_across_Association_inst;
    }
    private O_TFR R126_delegates_execution_of_O_TFR_inst;
    @Override
    public void setR126_delegates_execution_of_O_TFR( O_TFR inst ) {
        R126_delegates_execution_of_O_TFR_inst = inst;
    }
    @Override
    public O_TFR R126_delegates_execution_of_O_TFR() throws XtumlException {
        return R126_delegates_execution_of_O_TFR_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Deferral value() {
        return this;
    }

    @Override
    public Deferral self() {
        return this;
    }

    @Override
    public Deferral oneWhere( IWhere<Deferral> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_DEFERRAL;
    }

}

class EmptyDeferral extends ModelInstance<Deferral,Sql> implements Deferral {

    // attributes
    public void setTfr_ID( UniqueId ref_Tfr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getTfr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getRel_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Association R126_defers_execution_to_subtypes_across_Association() {
        return AssociationImpl.EMPTY_ASSOCIATION;
    }
    @Override
    public O_TFR R126_delegates_execution_of_O_TFR() {
        return O_TFRImpl.EMPTY_O_TFR;
    }


    @Override
    public String getKeyLetters() {
        return DeferralImpl.KEY_LETTERS;
    }

    @Override
    public Deferral value() {
        return this;
    }
    
    @Override
    public Deferral self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Deferral oneWhere( IWhere<Deferral> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return DeferralImpl.EMPTY_DEFERRAL;
    }

}
