package io.ciera.tool.sql.ooaofooa.subsystem.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.ReferringClassInAssoc;
import io.ciera.tool.sql.ooaofooa.association.impl.ReferringClassInAssocImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.AttributeReferenceInClass;
import io.ciera.tool.sql.ooaofooa.subsystem.ReferentialAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.ReferredToIdentifierAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.AttributeReferenceInClassImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ReferentialAttributeImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ReferredToIdentifierAttributeImpl;


public class AttributeReferenceInClassImpl extends ModelInstance<AttributeReferenceInClass,Sql> implements AttributeReferenceInClass {

    public static final String KEY_LETTERS = "O_REF";
    public static final AttributeReferenceInClass EMPTY_ATTRIBUTEREFERENCEINCLASS = new EmptyAttributeReferenceInClass();

    private Sql context;

    // constructors
    private AttributeReferenceInClassImpl( Sql context ) {
        this.context = context;
        ref_Obj_ID = UniqueId.random();
        ref_RObj_ID = UniqueId.random();
        ref_ROid_ID = 0;
        ref_RAttr_ID = UniqueId.random();
        ref_Rel_ID = UniqueId.random();
        ref_OIR_ID = UniqueId.random();
        ref_ROIR_ID = UniqueId.random();
        ref_Attr_ID = UniqueId.random();
        m_ARef_ID = UniqueId.random();
        ref_PARef_ID = UniqueId.random();
        m_Is_Cstrd = false;
        m_Descrip = "";
        m_RObj_Name = "";
        m_RAttr_Name = "";
        m_Rel_Name = "";
        R108_is_resolved_by_ReferentialAttribute_inst = ReferentialAttributeImpl.EMPTY_REFERENTIALATTRIBUTE;
        R111_is_used_to_refer_class_by_ReferringClassInAssoc_inst = ReferringClassInAssocImpl.EMPTY_REFERRINGCLASSINASSOC;
        R111_refers_across_association_via_ReferredToIdentifierAttribute_inst = ReferredToIdentifierAttributeImpl.EMPTY_REFERREDTOIDENTIFIERATTRIBUTE;
        R112_precedes_AttributeReferenceInClass_inst = AttributeReferenceInClassImpl.EMPTY_ATTRIBUTEREFERENCEINCLASS;
        R112_succeeds_AttributeReferenceInClass_inst = AttributeReferenceInClassImpl.EMPTY_ATTRIBUTEREFERENCEINCLASS;
    }

    private AttributeReferenceInClassImpl( Sql context, UniqueId instanceId, UniqueId ref_Obj_ID, UniqueId ref_RObj_ID, int ref_ROid_ID, UniqueId ref_RAttr_ID, UniqueId ref_Rel_ID, UniqueId ref_OIR_ID, UniqueId ref_ROIR_ID, UniqueId ref_Attr_ID, UniqueId m_ARef_ID, UniqueId ref_PARef_ID, boolean m_Is_Cstrd, String m_Descrip, String m_RObj_Name, String m_RAttr_Name, String m_Rel_Name ) {
        super(instanceId);
        this.context = context;
        this.ref_Obj_ID = ref_Obj_ID;
        this.ref_RObj_ID = ref_RObj_ID;
        this.ref_ROid_ID = ref_ROid_ID;
        this.ref_RAttr_ID = ref_RAttr_ID;
        this.ref_Rel_ID = ref_Rel_ID;
        this.ref_OIR_ID = ref_OIR_ID;
        this.ref_ROIR_ID = ref_ROIR_ID;
        this.ref_Attr_ID = ref_Attr_ID;
        this.m_ARef_ID = m_ARef_ID;
        this.ref_PARef_ID = ref_PARef_ID;
        this.m_Is_Cstrd = m_Is_Cstrd;
        this.m_Descrip = m_Descrip;
        this.m_RObj_Name = m_RObj_Name;
        this.m_RAttr_Name = m_RAttr_Name;
        this.m_Rel_Name = m_Rel_Name;
        R108_is_resolved_by_ReferentialAttribute_inst = ReferentialAttributeImpl.EMPTY_REFERENTIALATTRIBUTE;
        R111_is_used_to_refer_class_by_ReferringClassInAssoc_inst = ReferringClassInAssocImpl.EMPTY_REFERRINGCLASSINASSOC;
        R111_refers_across_association_via_ReferredToIdentifierAttribute_inst = ReferredToIdentifierAttributeImpl.EMPTY_REFERREDTOIDENTIFIERATTRIBUTE;
        R112_precedes_AttributeReferenceInClass_inst = AttributeReferenceInClassImpl.EMPTY_ATTRIBUTEREFERENCEINCLASS;
        R112_succeeds_AttributeReferenceInClass_inst = AttributeReferenceInClassImpl.EMPTY_ATTRIBUTEREFERENCEINCLASS;
    }

    public static AttributeReferenceInClass create( Sql context ) throws XtumlException {
        AttributeReferenceInClass newAttributeReferenceInClass = new AttributeReferenceInClassImpl( context );
        if ( context.addInstance( newAttributeReferenceInClass ) ) {
            newAttributeReferenceInClass.getRunContext().addChange(new InstanceCreatedDelta(newAttributeReferenceInClass, KEY_LETTERS));
            return newAttributeReferenceInClass;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static AttributeReferenceInClass create( Sql context, UniqueId instanceId, UniqueId ref_Obj_ID, UniqueId ref_RObj_ID, int ref_ROid_ID, UniqueId ref_RAttr_ID, UniqueId ref_Rel_ID, UniqueId ref_OIR_ID, UniqueId ref_ROIR_ID, UniqueId ref_Attr_ID, UniqueId m_ARef_ID, UniqueId ref_PARef_ID, boolean m_Is_Cstrd, String m_Descrip, String m_RObj_Name, String m_RAttr_Name, String m_Rel_Name ) throws XtumlException {
        AttributeReferenceInClass newAttributeReferenceInClass = new AttributeReferenceInClassImpl( context, instanceId, ref_Obj_ID, ref_RObj_ID, ref_ROid_ID, ref_RAttr_ID, ref_Rel_ID, ref_OIR_ID, ref_ROIR_ID, ref_Attr_ID, m_ARef_ID, ref_PARef_ID, m_Is_Cstrd, m_Descrip, m_RObj_Name, m_RAttr_Name, m_Rel_Name );
        if ( context.addInstance( newAttributeReferenceInClass ) ) {
            return newAttributeReferenceInClass;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Obj_ID.inequality( this.ref_Obj_ID ) ) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
                return ref_Obj_ID;
    }
    private UniqueId ref_RObj_ID;
    @Override
    public void setRObj_ID( UniqueId ref_RObj_ID ) throws XtumlException {
        checkLiving();
        if ( ref_RObj_ID.inequality( this.ref_RObj_ID ) ) {
            final UniqueId oldValue = this.ref_RObj_ID;
            this.ref_RObj_ID = ref_RObj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_RObj_ID", oldValue, this.ref_RObj_ID));
        }
    }
    @Override
    public UniqueId getRObj_ID() throws XtumlException {
        checkLiving();
                return ref_RObj_ID;
    }
    private int ref_ROid_ID;
    @Override
    public int getROid_ID() throws XtumlException {
        checkLiving();
                return ref_ROid_ID;
    }
    @Override
    public void setROid_ID( int ref_ROid_ID ) throws XtumlException {
        checkLiving();
        if ( ref_ROid_ID != this.ref_ROid_ID ) {
            final int oldValue = this.ref_ROid_ID;
            this.ref_ROid_ID = ref_ROid_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_ROid_ID", oldValue, this.ref_ROid_ID));
        }
    }
    private UniqueId ref_RAttr_ID;
    @Override
    public void setRAttr_ID( UniqueId ref_RAttr_ID ) throws XtumlException {
        checkLiving();
        if ( ref_RAttr_ID.inequality( this.ref_RAttr_ID ) ) {
            final UniqueId oldValue = this.ref_RAttr_ID;
            this.ref_RAttr_ID = ref_RAttr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_RAttr_ID", oldValue, this.ref_RAttr_ID));
        }
    }
    @Override
    public UniqueId getRAttr_ID() throws XtumlException {
        checkLiving();
                return ref_RAttr_ID;
    }
    private UniqueId ref_Rel_ID;
    @Override
    public UniqueId getRel_ID() throws XtumlException {
        checkLiving();
                return ref_Rel_ID;
    }
    @Override
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Rel_ID.inequality( this.ref_Rel_ID ) ) {
            final UniqueId oldValue = this.ref_Rel_ID;
            this.ref_Rel_ID = ref_Rel_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Rel_ID", oldValue, this.ref_Rel_ID));
        }
    }
    private UniqueId ref_OIR_ID;
    @Override
    public UniqueId getOIR_ID() throws XtumlException {
        checkLiving();
                return ref_OIR_ID;
    }
    @Override
    public void setOIR_ID( UniqueId ref_OIR_ID ) throws XtumlException {
        checkLiving();
        if ( ref_OIR_ID.inequality( this.ref_OIR_ID ) ) {
            final UniqueId oldValue = this.ref_OIR_ID;
            this.ref_OIR_ID = ref_OIR_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_OIR_ID", oldValue, this.ref_OIR_ID));
        }
    }
    private UniqueId ref_ROIR_ID;
    @Override
    public void setROIR_ID( UniqueId ref_ROIR_ID ) throws XtumlException {
        checkLiving();
        if ( ref_ROIR_ID.inequality( this.ref_ROIR_ID ) ) {
            final UniqueId oldValue = this.ref_ROIR_ID;
            this.ref_ROIR_ID = ref_ROIR_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_ROIR_ID", oldValue, this.ref_ROIR_ID));
        }
    }
    @Override
    public UniqueId getROIR_ID() throws XtumlException {
        checkLiving();
                return ref_ROIR_ID;
    }
    private UniqueId ref_Attr_ID;
    @Override
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Attr_ID.inequality( this.ref_Attr_ID ) ) {
            final UniqueId oldValue = this.ref_Attr_ID;
            this.ref_Attr_ID = ref_Attr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Attr_ID", oldValue, this.ref_Attr_ID));
        }
    }
    @Override
    public UniqueId getAttr_ID() throws XtumlException {
        checkLiving();
                return ref_Attr_ID;
    }
    private UniqueId m_ARef_ID;
    @Override
    public void setARef_ID( UniqueId m_ARef_ID ) throws XtumlException {
        checkLiving();
        if ( m_ARef_ID.inequality( this.m_ARef_ID ) ) {
            final UniqueId oldValue = this.m_ARef_ID;
            this.m_ARef_ID = m_ARef_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_ARef_ID", oldValue, this.m_ARef_ID));
            if ( !R112_precedes_AttributeReferenceInClass().isEmpty() ) R112_precedes_AttributeReferenceInClass().setPARef_ID( m_ARef_ID );
        }
    }
    @Override
    public UniqueId getARef_ID() throws XtumlException {
        checkLiving();
                return m_ARef_ID;
    }
    private UniqueId ref_PARef_ID;
    @Override
    public UniqueId getPARef_ID() throws XtumlException {
        checkLiving();
                return ref_PARef_ID;
    }
    @Override
    public void setPARef_ID( UniqueId ref_PARef_ID ) throws XtumlException {
        checkLiving();
        if ( ref_PARef_ID.inequality( this.ref_PARef_ID ) ) {
            final UniqueId oldValue = this.ref_PARef_ID;
            this.ref_PARef_ID = ref_PARef_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_PARef_ID", oldValue, this.ref_PARef_ID));
        }
    }
    private boolean m_Is_Cstrd;
    @Override
    public boolean getIs_Cstrd() throws XtumlException {
        checkLiving();
                return m_Is_Cstrd;
    }
    @Override
    public void setIs_Cstrd( boolean m_Is_Cstrd ) throws XtumlException {
        checkLiving();
        if ( m_Is_Cstrd != this.m_Is_Cstrd ) {
            final boolean oldValue = this.m_Is_Cstrd;
            this.m_Is_Cstrd = m_Is_Cstrd;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Is_Cstrd", oldValue, this.m_Is_Cstrd));
        }
    }
    private String m_Descrip;
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Descrip, this.m_Descrip ) ) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
                return m_Descrip;
    }
    private String m_RObj_Name;
    @Override
    public void setRObj_Name( String m_RObj_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_RObj_Name, this.m_RObj_Name ) ) {
            final String oldValue = this.m_RObj_Name;
            this.m_RObj_Name = m_RObj_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_RObj_Name", oldValue, this.m_RObj_Name));
        }
    }
    @Override
    public String getRObj_Name() throws XtumlException {
        checkLiving();
                return m_RObj_Name;
    }
    private String m_RAttr_Name;
    @Override
    public void setRAttr_Name( String m_RAttr_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_RAttr_Name, this.m_RAttr_Name ) ) {
            final String oldValue = this.m_RAttr_Name;
            this.m_RAttr_Name = m_RAttr_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_RAttr_Name", oldValue, this.m_RAttr_Name));
        }
    }
    @Override
    public String getRAttr_Name() throws XtumlException {
        checkLiving();
                return m_RAttr_Name;
    }
    private String m_Rel_Name;
    @Override
    public String getRel_Name() throws XtumlException {
        checkLiving();
                return m_Rel_Name;
    }
    @Override
    public void setRel_Name( String m_Rel_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Rel_Name, this.m_Rel_Name ) ) {
            final String oldValue = this.m_Rel_Name;
            this.m_Rel_Name = m_Rel_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Rel_Name", oldValue, this.m_Rel_Name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getObj_ID(), getRObj_ID(), getROid_ID(), getRAttr_ID(), getRel_ID(), getOIR_ID(), getROIR_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }
    @Override
    public IInstanceIdentifier getId2() {
        try {
            return new InstanceIdentifier(getARef_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ReferentialAttribute R108_is_resolved_by_ReferentialAttribute_inst;
    @Override
    public void setR108_is_resolved_by_ReferentialAttribute( ReferentialAttribute inst ) {
        R108_is_resolved_by_ReferentialAttribute_inst = inst;
    }
    @Override
    public ReferentialAttribute R108_is_resolved_by_ReferentialAttribute() throws XtumlException {
        return R108_is_resolved_by_ReferentialAttribute_inst;
    }
    private ReferringClassInAssoc R111_is_used_to_refer_class_by_ReferringClassInAssoc_inst;
    @Override
    public void setR111_is_used_to_refer_class_by_ReferringClassInAssoc( ReferringClassInAssoc inst ) {
        R111_is_used_to_refer_class_by_ReferringClassInAssoc_inst = inst;
    }
    @Override
    public ReferringClassInAssoc R111_is_used_to_refer_class_by_ReferringClassInAssoc() throws XtumlException {
        return R111_is_used_to_refer_class_by_ReferringClassInAssoc_inst;
    }
    private ReferredToIdentifierAttribute R111_refers_across_association_via_ReferredToIdentifierAttribute_inst;
    @Override
    public void setR111_refers_across_association_via_ReferredToIdentifierAttribute( ReferredToIdentifierAttribute inst ) {
        R111_refers_across_association_via_ReferredToIdentifierAttribute_inst = inst;
    }
    @Override
    public ReferredToIdentifierAttribute R111_refers_across_association_via_ReferredToIdentifierAttribute() throws XtumlException {
        return R111_refers_across_association_via_ReferredToIdentifierAttribute_inst;
    }
    private AttributeReferenceInClass R112_precedes_AttributeReferenceInClass_inst;
    @Override
    public void setR112_precedes_AttributeReferenceInClass( AttributeReferenceInClass inst ) {
        R112_precedes_AttributeReferenceInClass_inst = inst;
    }
    @Override
    public AttributeReferenceInClass R112_precedes_AttributeReferenceInClass() throws XtumlException {
        return R112_precedes_AttributeReferenceInClass_inst;
    }
    private AttributeReferenceInClass R112_succeeds_AttributeReferenceInClass_inst;
    @Override
    public void setR112_succeeds_AttributeReferenceInClass( AttributeReferenceInClass inst ) {
        R112_succeeds_AttributeReferenceInClass_inst = inst;
    }
    @Override
    public AttributeReferenceInClass R112_succeeds_AttributeReferenceInClass() throws XtumlException {
        return R112_succeeds_AttributeReferenceInClass_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public AttributeReferenceInClass value() {
        return this;
    }

    @Override
    public AttributeReferenceInClass self() {
        return this;
    }

    @Override
    public AttributeReferenceInClass oneWhere( IWhere<AttributeReferenceInClass> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_ATTRIBUTEREFERENCEINCLASS;
    }

}

class EmptyAttributeReferenceInClass extends ModelInstance<AttributeReferenceInClass,Sql> implements AttributeReferenceInClass {

    // attributes
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRObj_ID( UniqueId ref_RObj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getROid_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setROid_ID( int ref_ROid_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setRAttr_ID( UniqueId ref_RAttr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRAttr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getRel_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getOIR_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setOIR_ID( UniqueId ref_OIR_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setROIR_ID( UniqueId ref_ROIR_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getROIR_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getAttr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setARef_ID( UniqueId m_ARef_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getARef_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getPARef_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPARef_ID( UniqueId ref_PARef_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIs_Cstrd() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIs_Cstrd( boolean m_Is_Cstrd ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRObj_Name( String m_RObj_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getRObj_Name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRAttr_Name( String m_RAttr_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getRAttr_Name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getRel_Name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_Name( String m_Rel_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ReferentialAttribute R108_is_resolved_by_ReferentialAttribute() {
        return ReferentialAttributeImpl.EMPTY_REFERENTIALATTRIBUTE;
    }
    @Override
    public ReferringClassInAssoc R111_is_used_to_refer_class_by_ReferringClassInAssoc() {
        return ReferringClassInAssocImpl.EMPTY_REFERRINGCLASSINASSOC;
    }
    @Override
    public ReferredToIdentifierAttribute R111_refers_across_association_via_ReferredToIdentifierAttribute() {
        return ReferredToIdentifierAttributeImpl.EMPTY_REFERREDTOIDENTIFIERATTRIBUTE;
    }
    @Override
    public AttributeReferenceInClass R112_precedes_AttributeReferenceInClass() {
        return AttributeReferenceInClassImpl.EMPTY_ATTRIBUTEREFERENCEINCLASS;
    }
    @Override
    public AttributeReferenceInClass R112_succeeds_AttributeReferenceInClass() {
        return AttributeReferenceInClassImpl.EMPTY_ATTRIBUTEREFERENCEINCLASS;
    }


    @Override
    public String getKeyLetters() {
        return AttributeReferenceInClassImpl.KEY_LETTERS;
    }

    @Override
    public AttributeReferenceInClass value() {
        return this;
    }
    
    @Override
    public AttributeReferenceInClass self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public AttributeReferenceInClass oneWhere( IWhere<AttributeReferenceInClass> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return AttributeReferenceInClassImpl.EMPTY_ATTRIBUTEREFERENCEINCLASS;
    }

}
