package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.statemachine.MealyActionHome;
import io.ciera.tool.sql.ooaofooa.statemachine.MealyActionHomeSet;
import io.ciera.tool.sql.ooaofooa.statemachine.MealyStateMachine;
import io.ciera.tool.sql.ooaofooa.statemachine.SM_SM;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.MealyActionHomeSetImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.SM_SMImpl;


public class MealyStateMachineImpl extends ModelInstance<MealyStateMachine,Sql> implements MealyStateMachine {

    public static final String KEY_LETTERS = "SM_MEALY";
    public static final MealyStateMachine EMPTY_MEALYSTATEMACHINE = new EmptyMealyStateMachine();

    private Sql context;

    // constructors
    private MealyStateMachineImpl( Sql context ) {
        this.context = context;
        ref_SM_ID = UniqueId.random();
        R510_is_a_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R512_MealyActionHome_set = new MealyActionHomeSetImpl();
    }

    private MealyStateMachineImpl( Sql context, UniqueId instanceId, UniqueId ref_SM_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_SM_ID = ref_SM_ID;
        R510_is_a_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R512_MealyActionHome_set = new MealyActionHomeSetImpl();
    }

    public static MealyStateMachine create( Sql context ) throws XtumlException {
        MealyStateMachine newMealyStateMachine = new MealyStateMachineImpl( context );
        if ( context.addInstance( newMealyStateMachine ) ) {
            newMealyStateMachine.getRunContext().addChange(new InstanceCreatedDelta(newMealyStateMachine, KEY_LETTERS));
            return newMealyStateMachine;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static MealyStateMachine create( Sql context, UniqueId instanceId, UniqueId ref_SM_ID ) throws XtumlException {
        MealyStateMachine newMealyStateMachine = new MealyStateMachineImpl( context, instanceId, ref_SM_ID );
        if ( context.addInstance( newMealyStateMachine ) ) {
            return newMealyStateMachine;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_SM_ID;
    @Override
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        checkLiving();
        if ( ref_SM_ID.inequality( this.ref_SM_ID ) ) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
            if ( !R512_MealyActionHome().isEmpty() ) R512_MealyActionHome().setSM_ID( ref_SM_ID );
        }
    }
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
                return ref_SM_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private SM_SM R510_is_a_SM_SM_inst;
    @Override
    public void setR510_is_a_SM_SM( SM_SM inst ) {
        R510_is_a_SM_SM_inst = inst;
    }
    @Override
    public SM_SM R510_is_a_SM_SM() throws XtumlException {
        return R510_is_a_SM_SM_inst;
    }
    private MealyActionHomeSet R512_MealyActionHome_set;
    @Override
    public void addR512_MealyActionHome( MealyActionHome inst ) {
        R512_MealyActionHome_set.add(inst);
    }
    @Override
    public void removeR512_MealyActionHome( MealyActionHome inst ) {
        R512_MealyActionHome_set.remove(inst);
    }
    @Override
    public MealyActionHomeSet R512_MealyActionHome() throws XtumlException {
        return R512_MealyActionHome_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public MealyStateMachine value() {
        return this;
    }

    @Override
    public MealyStateMachine self() {
        return this;
    }

    @Override
    public MealyStateMachine oneWhere( IWhere<MealyStateMachine> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_MEALYSTATEMACHINE;
    }

}

class EmptyMealyStateMachine extends ModelInstance<MealyStateMachine,Sql> implements MealyStateMachine {

    // attributes
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public SM_SM R510_is_a_SM_SM() {
        return SM_SMImpl.EMPTY_SM_SM;
    }
    @Override
    public MealyActionHomeSet R512_MealyActionHome() {
        return (new MealyActionHomeSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return MealyStateMachineImpl.KEY_LETTERS;
    }

    @Override
    public MealyStateMachine value() {
        return this;
    }
    
    @Override
    public MealyStateMachine self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public MealyStateMachine oneWhere( IWhere<MealyStateMachine> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return MealyStateMachineImpl.EMPTY_MEALYSTATEMACHINE;
    }

}
