package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.statemachine.InstanceStateMachine;
import io.ciera.tool.sql.ooaofooa.statemachine.SM_SM;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.SM_SMImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.ModelClass;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ModelClassImpl;


public class InstanceStateMachineImpl extends ModelInstance<InstanceStateMachine,Sql> implements InstanceStateMachine {

    public static final String KEY_LETTERS = "SM_ISM";
    public static final InstanceStateMachine EMPTY_INSTANCESTATEMACHINE = new EmptyInstanceStateMachine();

    private Sql context;

    // constructors
    private InstanceStateMachineImpl( Sql context ) {
        this.context = context;
        ref_SM_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        R517_is_a_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R518_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
    }

    private InstanceStateMachineImpl( Sql context, UniqueId instanceId, UniqueId ref_SM_ID, UniqueId ref_Obj_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_SM_ID = ref_SM_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        R517_is_a_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R518_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
    }

    public static InstanceStateMachine create( Sql context ) throws XtumlException {
        InstanceStateMachine newInstanceStateMachine = new InstanceStateMachineImpl( context );
        if ( context.addInstance( newInstanceStateMachine ) ) {
            newInstanceStateMachine.getRunContext().addChange(new InstanceCreatedDelta(newInstanceStateMachine, KEY_LETTERS));
            return newInstanceStateMachine;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InstanceStateMachine create( Sql context, UniqueId instanceId, UniqueId ref_SM_ID, UniqueId ref_Obj_ID ) throws XtumlException {
        InstanceStateMachine newInstanceStateMachine = new InstanceStateMachineImpl( context, instanceId, ref_SM_ID, ref_Obj_ID );
        if ( context.addInstance( newInstanceStateMachine ) ) {
            return newInstanceStateMachine;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_SM_ID;
    @Override
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        checkLiving();
        if ( ref_SM_ID.inequality( this.ref_SM_ID ) ) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
        }
    }
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
                return ref_SM_ID;
    }
    private UniqueId ref_Obj_ID;
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
                return ref_Obj_ID;
    }
    @Override
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Obj_ID.inequality( this.ref_Obj_ID ) ) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private SM_SM R517_is_a_SM_SM_inst;
    @Override
    public void setR517_is_a_SM_SM( SM_SM inst ) {
        R517_is_a_SM_SM_inst = inst;
    }
    @Override
    public SM_SM R517_is_a_SM_SM() throws XtumlException {
        return R517_is_a_SM_SM_inst;
    }
    private ModelClass R518_ModelClass_inst;
    @Override
    public void setR518_ModelClass( ModelClass inst ) {
        R518_ModelClass_inst = inst;
    }
    @Override
    public ModelClass R518_ModelClass() throws XtumlException {
        return R518_ModelClass_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InstanceStateMachine value() {
        return this;
    }

    @Override
    public InstanceStateMachine self() {
        return this;
    }

    @Override
    public InstanceStateMachine oneWhere( IWhere<InstanceStateMachine> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_INSTANCESTATEMACHINE;
    }

}

class EmptyInstanceStateMachine extends ModelInstance<InstanceStateMachine,Sql> implements InstanceStateMachine {

    // attributes
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public SM_SM R517_is_a_SM_SM() {
        return SM_SMImpl.EMPTY_SM_SM;
    }
    @Override
    public ModelClass R518_ModelClass() {
        return ModelClassImpl.EMPTY_MODELCLASS;
    }


    @Override
    public String getKeyLetters() {
        return InstanceStateMachineImpl.KEY_LETTERS;
    }

    @Override
    public InstanceStateMachine value() {
        return this;
    }
    
    @Override
    public InstanceStateMachine self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InstanceStateMachine oneWhere( IWhere<InstanceStateMachine> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return InstanceStateMachineImpl.EMPTY_INSTANCESTATEMACHINE;
    }

}
