package io.ciera.tool.sql.ooaofooa.packageableelement.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.C_C;
import io.ciera.tool.sql.ooaofooa.component.impl.C_CImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.ComponentResultSet;
import io.ciera.tool.sql.ooaofooa.packageableelement.ComponentVisibility;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.ComponentResultSetImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;

import ooaofooa.datatypes.ElementTypeConstants;


public class ComponentVisibilityImpl extends ModelInstance<ComponentVisibility,Sql> implements ComponentVisibility {

    public static final String KEY_LETTERS = "PE_CVS";
    public static final ComponentVisibility EMPTY_COMPONENTVISIBILITY = new EmptyComponentVisibility();

    private Sql context;

    // constructors
    private ComponentVisibilityImpl( Sql context ) {
        this.context = context;
        m_Visibility_ID = UniqueId.random();
        ref_Element_ID = UniqueId.random();
        ref_Id = UniqueId.random();
        ref_Name = "";
        ref_Type = ElementTypeConstants.UNINITIALIZED_ENUM;
        R8004_has_visibility_of_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R8004_is_visible_to_C_C_inst = C_CImpl.EMPTY_C_C;
        R8008_makes_up_a_ComponentResultSet_inst = ComponentResultSetImpl.EMPTY_COMPONENTRESULTSET;
    }

    private ComponentVisibilityImpl( Sql context, UniqueId instanceId, UniqueId m_Visibility_ID, UniqueId ref_Element_ID, UniqueId ref_Id, String ref_Name, ElementTypeConstants ref_Type ) {
        super(instanceId);
        this.context = context;
        this.m_Visibility_ID = m_Visibility_ID;
        this.ref_Element_ID = ref_Element_ID;
        this.ref_Id = ref_Id;
        this.ref_Name = ref_Name;
        this.ref_Type = ref_Type;
        R8004_has_visibility_of_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R8004_is_visible_to_C_C_inst = C_CImpl.EMPTY_C_C;
        R8008_makes_up_a_ComponentResultSet_inst = ComponentResultSetImpl.EMPTY_COMPONENTRESULTSET;
    }

    public static ComponentVisibility create( Sql context ) throws XtumlException {
        ComponentVisibility newComponentVisibility = new ComponentVisibilityImpl( context );
        if ( context.addInstance( newComponentVisibility ) ) {
            newComponentVisibility.getRunContext().addChange(new InstanceCreatedDelta(newComponentVisibility, KEY_LETTERS));
            return newComponentVisibility;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ComponentVisibility create( Sql context, UniqueId instanceId, UniqueId m_Visibility_ID, UniqueId ref_Element_ID, UniqueId ref_Id, String ref_Name, ElementTypeConstants ref_Type ) throws XtumlException {
        ComponentVisibility newComponentVisibility = new ComponentVisibilityImpl( context, instanceId, m_Visibility_ID, ref_Element_ID, ref_Id, ref_Name, ref_Type );
        if ( context.addInstance( newComponentVisibility ) ) {
            return newComponentVisibility;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Visibility_ID;
    @Override
    public UniqueId getVisibility_ID() throws XtumlException {
        checkLiving();
                return m_Visibility_ID;
    }
    @Override
    public void setVisibility_ID( UniqueId m_Visibility_ID ) throws XtumlException {
        checkLiving();
        if ( m_Visibility_ID.inequality( this.m_Visibility_ID ) ) {
            final UniqueId oldValue = this.m_Visibility_ID;
            this.m_Visibility_ID = m_Visibility_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Visibility_ID", oldValue, this.m_Visibility_ID));
        }
    }
    private UniqueId ref_Element_ID;
    @Override
    public void setElement_ID( UniqueId ref_Element_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Element_ID.inequality( this.ref_Element_ID ) ) {
            final UniqueId oldValue = this.ref_Element_ID;
            this.ref_Element_ID = ref_Element_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Element_ID", oldValue, this.ref_Element_ID));
        }
    }
    @Override
    public UniqueId getElement_ID() throws XtumlException {
        checkLiving();
                return ref_Element_ID;
    }
    private UniqueId ref_Id;
    @Override
    public void setId( UniqueId ref_Id ) throws XtumlException {
        checkLiving();
        if ( ref_Id.inequality( this.ref_Id ) ) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
                return ref_Id;
    }
    private String ref_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return ref_Name;
    }
    @Override
    public void setName( String ref_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_Name, this.ref_Name ) ) {
            final String oldValue = this.ref_Name;
            this.ref_Name = ref_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Name", oldValue, this.ref_Name));
        }
    }
    private ElementTypeConstants ref_Type;
    @Override
    public void setType( ElementTypeConstants ref_Type ) throws XtumlException {
        checkLiving();
        if ( ref_Type.inequality( this.ref_Type ) ) {
            final ElementTypeConstants oldValue = this.ref_Type;
            this.ref_Type = ref_Type;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Type", oldValue, this.ref_Type));
        }
    }
    @Override
    public ElementTypeConstants getType() throws XtumlException {
        checkLiving();
                return ref_Type;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getVisibility_ID(), getElement_ID(), getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private PackageableElement R8004_has_visibility_of_PackageableElement_inst;
    @Override
    public void setR8004_has_visibility_of_PackageableElement( PackageableElement inst ) {
        R8004_has_visibility_of_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8004_has_visibility_of_PackageableElement() throws XtumlException {
        return R8004_has_visibility_of_PackageableElement_inst;
    }
    private C_C R8004_is_visible_to_C_C_inst;
    @Override
    public void setR8004_is_visible_to_C_C( C_C inst ) {
        R8004_is_visible_to_C_C_inst = inst;
    }
    @Override
    public C_C R8004_is_visible_to_C_C() throws XtumlException {
        return R8004_is_visible_to_C_C_inst;
    }
    private ComponentResultSet R8008_makes_up_a_ComponentResultSet_inst;
    @Override
    public void setR8008_makes_up_a_ComponentResultSet( ComponentResultSet inst ) {
        R8008_makes_up_a_ComponentResultSet_inst = inst;
    }
    @Override
    public ComponentResultSet R8008_makes_up_a_ComponentResultSet() throws XtumlException {
        return R8008_makes_up_a_ComponentResultSet_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ComponentVisibility value() {
        return this;
    }

    @Override
    public ComponentVisibility self() {
        return this;
    }

    @Override
    public ComponentVisibility oneWhere( IWhere<ComponentVisibility> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_COMPONENTVISIBILITY;
    }

}

class EmptyComponentVisibility extends ModelInstance<ComponentVisibility,Sql> implements ComponentVisibility {

    // attributes
    public UniqueId getVisibility_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVisibility_ID( UniqueId m_Visibility_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setElement_ID( UniqueId ref_Element_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getElement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String ref_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setType( ElementTypeConstants ref_Type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ElementTypeConstants getType() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public PackageableElement R8004_has_visibility_of_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }
    @Override
    public C_C R8004_is_visible_to_C_C() {
        return C_CImpl.EMPTY_C_C;
    }
    @Override
    public ComponentResultSet R8008_makes_up_a_ComponentResultSet() {
        return ComponentResultSetImpl.EMPTY_COMPONENTRESULTSET;
    }


    @Override
    public String getKeyLetters() {
        return ComponentVisibilityImpl.KEY_LETTERS;
    }

    @Override
    public ComponentVisibility value() {
        return this;
    }
    
    @Override
    public ComponentVisibility self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ComponentVisibility oneWhere( IWhere<ComponentVisibility> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return ComponentVisibilityImpl.EMPTY_COMPONENTVISIBILITY;
    }

}
