package io.ciera.tool.sql.ooaofooa.interaction.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.communication.CommunicationLink;
import io.ciera.tool.sql.ooaofooa.communication.CommunicationLinkSet;
import io.ciera.tool.sql.ooaofooa.communication.impl.CommunicationLinkSetImpl;
import io.ciera.tool.sql.ooaofooa.interaction.ActorParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.ClassInstanceParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.ClassParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.ComponentParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.ExternalEntityParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.InteractionParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.Lifespan;
import io.ciera.tool.sql.ooaofooa.interaction.PackageParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.UseCaseParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.impl.ActorParticipantImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.ClassInstanceParticipantImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.ClassParticipantImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.ComponentParticipantImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.ExternalEntityParticipantImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.LifespanImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.PackageParticipantImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.UseCaseParticipantImpl;
import io.ciera.tool.sql.ooaofooa.message.MSG_M;
import io.ciera.tool.sql.ooaofooa.message.MSG_MSet;
import io.ciera.tool.sql.ooaofooa.message.impl.MSG_MSetImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;
import io.ciera.tool.sql.ooaofooa.usecase.UseCaseAssociation;
import io.ciera.tool.sql.ooaofooa.usecase.UseCaseAssociationSet;
import io.ciera.tool.sql.ooaofooa.usecase.impl.UseCaseAssociationSetImpl;


public class InteractionParticipantImpl extends ModelInstance<InteractionParticipant,Sql> implements InteractionParticipant {

    public static final String KEY_LETTERS = "SQ_P";
    public static final InteractionParticipant EMPTY_INTERACTIONPARTICIPANT = new EmptyInteractionParticipant();

    private Sql context;

    // constructors
    private InteractionParticipantImpl( Sql context ) {
        this.context = context;
        ref_Part_ID = UniqueId.random();
        m_Sequence_Package_IDdeprecated = UniqueId.random();
        R1007_receives_MSG_M_set = new MSG_MSetImpl();
        R1008_sends_MSG_M_set = new MSG_MSetImpl();
        R1133_is_start_point_CommunicationLink_set = new CommunicationLinkSetImpl();
        R1134_is_destination_CommunicationLink_set = new CommunicationLinkSetImpl();
        R1206_is_source_UseCaseAssociation_set = new UseCaseAssociationSetImpl();
        R1207_is_destination_UseCaseAssociation_set = new UseCaseAssociationSetImpl();
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R930_is_a_ActorParticipant_inst = ActorParticipantImpl.EMPTY_ACTORPARTICIPANT;
        R930_is_a_ClassInstanceParticipant_inst = ClassInstanceParticipantImpl.EMPTY_CLASSINSTANCEPARTICIPANT;
        R930_is_a_ClassParticipant_inst = ClassParticipantImpl.EMPTY_CLASSPARTICIPANT;
        R930_is_a_ComponentParticipant_inst = ComponentParticipantImpl.EMPTY_COMPONENTPARTICIPANT;
        R930_is_a_ExternalEntityParticipant_inst = ExternalEntityParticipantImpl.EMPTY_EXTERNALENTITYPARTICIPANT;
        R930_is_a_Lifespan_inst = LifespanImpl.EMPTY_LIFESPAN;
        R930_is_a_PackageParticipant_inst = PackageParticipantImpl.EMPTY_PACKAGEPARTICIPANT;
        R930_is_a_UseCaseParticipant_inst = UseCaseParticipantImpl.EMPTY_USECASEPARTICIPANT;
        R940_is_source_of_span_Lifespan_inst = LifespanImpl.EMPTY_LIFESPAN;
    }

    private InteractionParticipantImpl( Sql context, UniqueId instanceId, UniqueId ref_Part_ID, UniqueId m_Sequence_Package_IDdeprecated ) {
        super(instanceId);
        this.context = context;
        this.ref_Part_ID = ref_Part_ID;
        this.m_Sequence_Package_IDdeprecated = m_Sequence_Package_IDdeprecated;
        R1007_receives_MSG_M_set = new MSG_MSetImpl();
        R1008_sends_MSG_M_set = new MSG_MSetImpl();
        R1133_is_start_point_CommunicationLink_set = new CommunicationLinkSetImpl();
        R1134_is_destination_CommunicationLink_set = new CommunicationLinkSetImpl();
        R1206_is_source_UseCaseAssociation_set = new UseCaseAssociationSetImpl();
        R1207_is_destination_UseCaseAssociation_set = new UseCaseAssociationSetImpl();
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R930_is_a_ActorParticipant_inst = ActorParticipantImpl.EMPTY_ACTORPARTICIPANT;
        R930_is_a_ClassInstanceParticipant_inst = ClassInstanceParticipantImpl.EMPTY_CLASSINSTANCEPARTICIPANT;
        R930_is_a_ClassParticipant_inst = ClassParticipantImpl.EMPTY_CLASSPARTICIPANT;
        R930_is_a_ComponentParticipant_inst = ComponentParticipantImpl.EMPTY_COMPONENTPARTICIPANT;
        R930_is_a_ExternalEntityParticipant_inst = ExternalEntityParticipantImpl.EMPTY_EXTERNALENTITYPARTICIPANT;
        R930_is_a_Lifespan_inst = LifespanImpl.EMPTY_LIFESPAN;
        R930_is_a_PackageParticipant_inst = PackageParticipantImpl.EMPTY_PACKAGEPARTICIPANT;
        R930_is_a_UseCaseParticipant_inst = UseCaseParticipantImpl.EMPTY_USECASEPARTICIPANT;
        R940_is_source_of_span_Lifespan_inst = LifespanImpl.EMPTY_LIFESPAN;
    }

    public static InteractionParticipant create( Sql context ) throws XtumlException {
        InteractionParticipant newInteractionParticipant = new InteractionParticipantImpl( context );
        if ( context.addInstance( newInteractionParticipant ) ) {
            newInteractionParticipant.getRunContext().addChange(new InstanceCreatedDelta(newInteractionParticipant, KEY_LETTERS));
            return newInteractionParticipant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InteractionParticipant create( Sql context, UniqueId instanceId, UniqueId ref_Part_ID, UniqueId m_Sequence_Package_IDdeprecated ) throws XtumlException {
        InteractionParticipant newInteractionParticipant = new InteractionParticipantImpl( context, instanceId, ref_Part_ID, m_Sequence_Package_IDdeprecated );
        if ( context.addInstance( newInteractionParticipant ) ) {
            return newInteractionParticipant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Part_ID;
    @Override
    public void setPart_ID( UniqueId ref_Part_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Part_ID.inequality( this.ref_Part_ID ) ) {
            final UniqueId oldValue = this.ref_Part_ID;
            this.ref_Part_ID = ref_Part_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Part_ID", oldValue, this.ref_Part_ID));
            if ( !R930_is_a_ExternalEntityParticipant().isEmpty() ) R930_is_a_ExternalEntityParticipant().setPart_ID( ref_Part_ID );
            if ( !R1007_receives_MSG_M().isEmpty() ) R1007_receives_MSG_M().setSender_Part_ID( ref_Part_ID );
            if ( !R930_is_a_UseCaseParticipant().isEmpty() ) R930_is_a_UseCaseParticipant().setPart_ID( ref_Part_ID );
            if ( !R930_is_a_ActorParticipant().isEmpty() ) R930_is_a_ActorParticipant().setPart_ID( ref_Part_ID );
            if ( !R930_is_a_Lifespan().isEmpty() ) R930_is_a_Lifespan().setPart_ID( ref_Part_ID );
            if ( !R1206_is_source_UseCaseAssociation().isEmpty() ) R1206_is_source_UseCaseAssociation().setSource_Part_ID( ref_Part_ID );
            if ( !R1008_sends_MSG_M().isEmpty() ) R1008_sends_MSG_M().setReceiver_Part_ID( ref_Part_ID );
            if ( !R930_is_a_ComponentParticipant().isEmpty() ) R930_is_a_ComponentParticipant().setPart_ID( ref_Part_ID );
            if ( !R930_is_a_ClassInstanceParticipant().isEmpty() ) R930_is_a_ClassInstanceParticipant().setPart_ID( ref_Part_ID );
            if ( !R930_is_a_PackageParticipant().isEmpty() ) R930_is_a_PackageParticipant().setPart_ID( ref_Part_ID );
            if ( !R1207_is_destination_UseCaseAssociation().isEmpty() ) R1207_is_destination_UseCaseAssociation().setDestination_Part_ID( ref_Part_ID );
            if ( !R930_is_a_ClassParticipant().isEmpty() ) R930_is_a_ClassParticipant().setPart_ID( ref_Part_ID );
            if ( !R940_is_source_of_span_Lifespan().isEmpty() ) R940_is_source_of_span_Lifespan().setSource_Part_ID( ref_Part_ID );
            if ( !R1134_is_destination_CommunicationLink().isEmpty() ) R1134_is_destination_CommunicationLink().setDestination_Part_ID( ref_Part_ID );
            if ( !R1133_is_start_point_CommunicationLink().isEmpty() ) R1133_is_start_point_CommunicationLink().setStart_Part_ID( ref_Part_ID );
        }
    }
    @Override
    public UniqueId getPart_ID() throws XtumlException {
        checkLiving();
                return ref_Part_ID;
    }
    private UniqueId m_Sequence_Package_IDdeprecated;
    @Override
    public UniqueId getSequence_Package_IDdeprecated() throws XtumlException {
        checkLiving();
                return m_Sequence_Package_IDdeprecated;
    }
    @Override
    public void setSequence_Package_IDdeprecated( UniqueId m_Sequence_Package_IDdeprecated ) throws XtumlException {
        checkLiving();
        if ( m_Sequence_Package_IDdeprecated.inequality( this.m_Sequence_Package_IDdeprecated ) ) {
            final UniqueId oldValue = this.m_Sequence_Package_IDdeprecated;
            this.m_Sequence_Package_IDdeprecated = m_Sequence_Package_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Sequence_Package_IDdeprecated", oldValue, this.m_Sequence_Package_IDdeprecated));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getPart_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private MSG_MSet R1007_receives_MSG_M_set;
    @Override
    public void addR1007_receives_MSG_M( MSG_M inst ) {
        R1007_receives_MSG_M_set.add(inst);
    }
    @Override
    public void removeR1007_receives_MSG_M( MSG_M inst ) {
        R1007_receives_MSG_M_set.remove(inst);
    }
    @Override
    public MSG_MSet R1007_receives_MSG_M() throws XtumlException {
        return R1007_receives_MSG_M_set;
    }
    private MSG_MSet R1008_sends_MSG_M_set;
    @Override
    public void addR1008_sends_MSG_M( MSG_M inst ) {
        R1008_sends_MSG_M_set.add(inst);
    }
    @Override
    public void removeR1008_sends_MSG_M( MSG_M inst ) {
        R1008_sends_MSG_M_set.remove(inst);
    }
    @Override
    public MSG_MSet R1008_sends_MSG_M() throws XtumlException {
        return R1008_sends_MSG_M_set;
    }
    private CommunicationLinkSet R1133_is_start_point_CommunicationLink_set;
    @Override
    public void addR1133_is_start_point_CommunicationLink( CommunicationLink inst ) {
        R1133_is_start_point_CommunicationLink_set.add(inst);
    }
    @Override
    public void removeR1133_is_start_point_CommunicationLink( CommunicationLink inst ) {
        R1133_is_start_point_CommunicationLink_set.remove(inst);
    }
    @Override
    public CommunicationLinkSet R1133_is_start_point_CommunicationLink() throws XtumlException {
        return R1133_is_start_point_CommunicationLink_set;
    }
    private CommunicationLinkSet R1134_is_destination_CommunicationLink_set;
    @Override
    public void addR1134_is_destination_CommunicationLink( CommunicationLink inst ) {
        R1134_is_destination_CommunicationLink_set.add(inst);
    }
    @Override
    public void removeR1134_is_destination_CommunicationLink( CommunicationLink inst ) {
        R1134_is_destination_CommunicationLink_set.remove(inst);
    }
    @Override
    public CommunicationLinkSet R1134_is_destination_CommunicationLink() throws XtumlException {
        return R1134_is_destination_CommunicationLink_set;
    }
    private UseCaseAssociationSet R1206_is_source_UseCaseAssociation_set;
    @Override
    public void addR1206_is_source_UseCaseAssociation( UseCaseAssociation inst ) {
        R1206_is_source_UseCaseAssociation_set.add(inst);
    }
    @Override
    public void removeR1206_is_source_UseCaseAssociation( UseCaseAssociation inst ) {
        R1206_is_source_UseCaseAssociation_set.remove(inst);
    }
    @Override
    public UseCaseAssociationSet R1206_is_source_UseCaseAssociation() throws XtumlException {
        return R1206_is_source_UseCaseAssociation_set;
    }
    private UseCaseAssociationSet R1207_is_destination_UseCaseAssociation_set;
    @Override
    public void addR1207_is_destination_UseCaseAssociation( UseCaseAssociation inst ) {
        R1207_is_destination_UseCaseAssociation_set.add(inst);
    }
    @Override
    public void removeR1207_is_destination_UseCaseAssociation( UseCaseAssociation inst ) {
        R1207_is_destination_UseCaseAssociation_set.remove(inst);
    }
    @Override
    public UseCaseAssociationSet R1207_is_destination_UseCaseAssociation() throws XtumlException {
        return R1207_is_destination_UseCaseAssociation_set;
    }
    private PackageableElement R8001_is_a_PackageableElement_inst;
    @Override
    public void setR8001_is_a_PackageableElement( PackageableElement inst ) {
        R8001_is_a_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() throws XtumlException {
        return R8001_is_a_PackageableElement_inst;
    }
    private ActorParticipant R930_is_a_ActorParticipant_inst;
    @Override
    public void setR930_is_a_ActorParticipant( ActorParticipant inst ) {
        R930_is_a_ActorParticipant_inst = inst;
    }
    @Override
    public ActorParticipant R930_is_a_ActorParticipant() throws XtumlException {
        return R930_is_a_ActorParticipant_inst;
    }
    private ClassInstanceParticipant R930_is_a_ClassInstanceParticipant_inst;
    @Override
    public void setR930_is_a_ClassInstanceParticipant( ClassInstanceParticipant inst ) {
        R930_is_a_ClassInstanceParticipant_inst = inst;
    }
    @Override
    public ClassInstanceParticipant R930_is_a_ClassInstanceParticipant() throws XtumlException {
        return R930_is_a_ClassInstanceParticipant_inst;
    }
    private ClassParticipant R930_is_a_ClassParticipant_inst;
    @Override
    public void setR930_is_a_ClassParticipant( ClassParticipant inst ) {
        R930_is_a_ClassParticipant_inst = inst;
    }
    @Override
    public ClassParticipant R930_is_a_ClassParticipant() throws XtumlException {
        return R930_is_a_ClassParticipant_inst;
    }
    private ComponentParticipant R930_is_a_ComponentParticipant_inst;
    @Override
    public void setR930_is_a_ComponentParticipant( ComponentParticipant inst ) {
        R930_is_a_ComponentParticipant_inst = inst;
    }
    @Override
    public ComponentParticipant R930_is_a_ComponentParticipant() throws XtumlException {
        return R930_is_a_ComponentParticipant_inst;
    }
    private ExternalEntityParticipant R930_is_a_ExternalEntityParticipant_inst;
    @Override
    public void setR930_is_a_ExternalEntityParticipant( ExternalEntityParticipant inst ) {
        R930_is_a_ExternalEntityParticipant_inst = inst;
    }
    @Override
    public ExternalEntityParticipant R930_is_a_ExternalEntityParticipant() throws XtumlException {
        return R930_is_a_ExternalEntityParticipant_inst;
    }
    private Lifespan R930_is_a_Lifespan_inst;
    @Override
    public void setR930_is_a_Lifespan( Lifespan inst ) {
        R930_is_a_Lifespan_inst = inst;
    }
    @Override
    public Lifespan R930_is_a_Lifespan() throws XtumlException {
        return R930_is_a_Lifespan_inst;
    }
    private PackageParticipant R930_is_a_PackageParticipant_inst;
    @Override
    public void setR930_is_a_PackageParticipant( PackageParticipant inst ) {
        R930_is_a_PackageParticipant_inst = inst;
    }
    @Override
    public PackageParticipant R930_is_a_PackageParticipant() throws XtumlException {
        return R930_is_a_PackageParticipant_inst;
    }
    private UseCaseParticipant R930_is_a_UseCaseParticipant_inst;
    @Override
    public void setR930_is_a_UseCaseParticipant( UseCaseParticipant inst ) {
        R930_is_a_UseCaseParticipant_inst = inst;
    }
    @Override
    public UseCaseParticipant R930_is_a_UseCaseParticipant() throws XtumlException {
        return R930_is_a_UseCaseParticipant_inst;
    }
    private Lifespan R940_is_source_of_span_Lifespan_inst;
    @Override
    public void setR940_is_source_of_span_Lifespan( Lifespan inst ) {
        R940_is_source_of_span_Lifespan_inst = inst;
    }
    @Override
    public Lifespan R940_is_source_of_span_Lifespan() throws XtumlException {
        return R940_is_source_of_span_Lifespan_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InteractionParticipant value() {
        return this;
    }

    @Override
    public InteractionParticipant self() {
        return this;
    }

    @Override
    public InteractionParticipant oneWhere( IWhere<InteractionParticipant> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_INTERACTIONPARTICIPANT;
    }

}

class EmptyInteractionParticipant extends ModelInstance<InteractionParticipant,Sql> implements InteractionParticipant {

    // attributes
    public void setPart_ID( UniqueId ref_Part_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPart_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getSequence_Package_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSequence_Package_IDdeprecated( UniqueId m_Sequence_Package_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public MSG_MSet R1007_receives_MSG_M() {
        return (new MSG_MSetImpl());
    }
    @Override
    public MSG_MSet R1008_sends_MSG_M() {
        return (new MSG_MSetImpl());
    }
    @Override
    public CommunicationLinkSet R1133_is_start_point_CommunicationLink() {
        return (new CommunicationLinkSetImpl());
    }
    @Override
    public CommunicationLinkSet R1134_is_destination_CommunicationLink() {
        return (new CommunicationLinkSetImpl());
    }
    @Override
    public UseCaseAssociationSet R1206_is_source_UseCaseAssociation() {
        return (new UseCaseAssociationSetImpl());
    }
    @Override
    public UseCaseAssociationSet R1207_is_destination_UseCaseAssociation() {
        return (new UseCaseAssociationSetImpl());
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }
    @Override
    public ActorParticipant R930_is_a_ActorParticipant() {
        return ActorParticipantImpl.EMPTY_ACTORPARTICIPANT;
    }
    @Override
    public ClassInstanceParticipant R930_is_a_ClassInstanceParticipant() {
        return ClassInstanceParticipantImpl.EMPTY_CLASSINSTANCEPARTICIPANT;
    }
    @Override
    public ClassParticipant R930_is_a_ClassParticipant() {
        return ClassParticipantImpl.EMPTY_CLASSPARTICIPANT;
    }
    @Override
    public ComponentParticipant R930_is_a_ComponentParticipant() {
        return ComponentParticipantImpl.EMPTY_COMPONENTPARTICIPANT;
    }
    @Override
    public ExternalEntityParticipant R930_is_a_ExternalEntityParticipant() {
        return ExternalEntityParticipantImpl.EMPTY_EXTERNALENTITYPARTICIPANT;
    }
    @Override
    public Lifespan R930_is_a_Lifespan() {
        return LifespanImpl.EMPTY_LIFESPAN;
    }
    @Override
    public PackageParticipant R930_is_a_PackageParticipant() {
        return PackageParticipantImpl.EMPTY_PACKAGEPARTICIPANT;
    }
    @Override
    public UseCaseParticipant R930_is_a_UseCaseParticipant() {
        return UseCaseParticipantImpl.EMPTY_USECASEPARTICIPANT;
    }
    @Override
    public Lifespan R940_is_source_of_span_Lifespan() {
        return LifespanImpl.EMPTY_LIFESPAN;
    }


    @Override
    public String getKeyLetters() {
        return InteractionParticipantImpl.KEY_LETTERS;
    }

    @Override
    public InteractionParticipant value() {
        return this;
    }
    
    @Override
    public InteractionParticipant self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InteractionParticipant oneWhere( IWhere<InteractionParticipant> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
    }

}
