package io.ciera.tool.sql.ooaofooa.interaction.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.interaction.ClassInstanceParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.FormalAttributeValue;
import io.ciera.tool.sql.ooaofooa.interaction.InformalAttributeValue;
import io.ciera.tool.sql.ooaofooa.interaction.InstanceAttributeValue;
import io.ciera.tool.sql.ooaofooa.interaction.impl.ClassInstanceParticipantImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.FormalAttributeValueImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.InformalAttributeValueImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.O_ATTR;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_ATTRImpl;


public class InstanceAttributeValueImpl extends ModelInstance<InstanceAttributeValue,Sql> implements InstanceAttributeValue {

    public static final String KEY_LETTERS = "SQ_AV";
    public static final InstanceAttributeValue EMPTY_INSTANCEATTRIBUTEVALUE = new EmptyInstanceAttributeValue();

    private Sql context;

    // constructors
    private InstanceAttributeValueImpl( Sql context ) {
        this.context = context;
        m_Av_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        ref_Attr_ID = UniqueId.random();
        m_Label = "";
        m_Value = "";
        m_InformalName = "";
        ref_Informal_Part_ID = UniqueId.random();
        ref_Formal_Part_ID = UniqueId.random();
        m_Descrip = "";
        m_isFormal = false;
        R936_owns_informal_ClassInstanceParticipant_inst = ClassInstanceParticipantImpl.EMPTY_CLASSINSTANCEPARTICIPANT;
        R937_owns_formal_ClassInstanceParticipant_inst = ClassInstanceParticipantImpl.EMPTY_CLASSINSTANCEPARTICIPANT;
        R938_references_O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
        R948_is_a_FormalAttributeValue_inst = FormalAttributeValueImpl.EMPTY_FORMALATTRIBUTEVALUE;
        R948_is_a_InformalAttributeValue_inst = InformalAttributeValueImpl.EMPTY_INFORMALATTRIBUTEVALUE;
    }

    private InstanceAttributeValueImpl( Sql context, UniqueId instanceId, UniqueId m_Av_ID, UniqueId ref_Obj_ID, UniqueId ref_Attr_ID, String m_Label, String m_Value, String m_InformalName, UniqueId ref_Informal_Part_ID, UniqueId ref_Formal_Part_ID, String m_Descrip, boolean m_isFormal ) {
        super(instanceId);
        this.context = context;
        this.m_Av_ID = m_Av_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        this.ref_Attr_ID = ref_Attr_ID;
        this.m_Label = m_Label;
        this.m_Value = m_Value;
        this.m_InformalName = m_InformalName;
        this.ref_Informal_Part_ID = ref_Informal_Part_ID;
        this.ref_Formal_Part_ID = ref_Formal_Part_ID;
        this.m_Descrip = m_Descrip;
        this.m_isFormal = m_isFormal;
        R936_owns_informal_ClassInstanceParticipant_inst = ClassInstanceParticipantImpl.EMPTY_CLASSINSTANCEPARTICIPANT;
        R937_owns_formal_ClassInstanceParticipant_inst = ClassInstanceParticipantImpl.EMPTY_CLASSINSTANCEPARTICIPANT;
        R938_references_O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
        R948_is_a_FormalAttributeValue_inst = FormalAttributeValueImpl.EMPTY_FORMALATTRIBUTEVALUE;
        R948_is_a_InformalAttributeValue_inst = InformalAttributeValueImpl.EMPTY_INFORMALATTRIBUTEVALUE;
    }

    public static InstanceAttributeValue create( Sql context ) throws XtumlException {
        InstanceAttributeValue newInstanceAttributeValue = new InstanceAttributeValueImpl( context );
        if ( context.addInstance( newInstanceAttributeValue ) ) {
            newInstanceAttributeValue.getRunContext().addChange(new InstanceCreatedDelta(newInstanceAttributeValue, KEY_LETTERS));
            return newInstanceAttributeValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InstanceAttributeValue create( Sql context, UniqueId instanceId, UniqueId m_Av_ID, UniqueId ref_Obj_ID, UniqueId ref_Attr_ID, String m_Label, String m_Value, String m_InformalName, UniqueId ref_Informal_Part_ID, UniqueId ref_Formal_Part_ID, String m_Descrip, boolean m_isFormal ) throws XtumlException {
        InstanceAttributeValue newInstanceAttributeValue = new InstanceAttributeValueImpl( context, instanceId, m_Av_ID, ref_Obj_ID, ref_Attr_ID, m_Label, m_Value, m_InformalName, ref_Informal_Part_ID, ref_Formal_Part_ID, m_Descrip, m_isFormal );
        if ( context.addInstance( newInstanceAttributeValue ) ) {
            return newInstanceAttributeValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Av_ID;
    @Override
    public UniqueId getAv_ID() throws XtumlException {
        checkLiving();
                return m_Av_ID;
    }
    @Override
    public void setAv_ID( UniqueId m_Av_ID ) throws XtumlException {
        checkLiving();
        if ( m_Av_ID.inequality( this.m_Av_ID ) ) {
            final UniqueId oldValue = this.m_Av_ID;
            this.m_Av_ID = m_Av_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Av_ID", oldValue, this.m_Av_ID));
            if ( !R948_is_a_InformalAttributeValue().isEmpty() ) R948_is_a_InformalAttributeValue().setAv_ID( m_Av_ID );
            if ( !R948_is_a_FormalAttributeValue().isEmpty() ) R948_is_a_FormalAttributeValue().setAv_ID( m_Av_ID );
        }
    }
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Obj_ID.inequality( this.ref_Obj_ID ) ) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
                return ref_Obj_ID;
    }
    private UniqueId ref_Attr_ID;
    @Override
    public UniqueId getAttr_ID() throws XtumlException {
        checkLiving();
                return ref_Attr_ID;
    }
    @Override
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Attr_ID.inequality( this.ref_Attr_ID ) ) {
            final UniqueId oldValue = this.ref_Attr_ID;
            this.ref_Attr_ID = ref_Attr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Attr_ID", oldValue, this.ref_Attr_ID));
        }
    }
    private String m_Label;
    @Override
    public String getLabel() throws XtumlException {
        checkLiving();
                return m_Label;
    }
    @Override
    public void setLabel( String m_Label ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Label, this.m_Label ) ) {
            final String oldValue = this.m_Label;
            this.m_Label = m_Label;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Label", oldValue, this.m_Label));
        }
    }
    private String m_Value;
    @Override
    public void setValue( String m_Value ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Value, this.m_Value ) ) {
            final String oldValue = this.m_Value;
            this.m_Value = m_Value;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Value", oldValue, this.m_Value));
        }
    }
    @Override
    public String getValue() throws XtumlException {
        checkLiving();
                return m_Value;
    }
    private String m_InformalName;
    @Override
    public String getInformalName() throws XtumlException {
        checkLiving();
                return m_InformalName;
    }
    @Override
    public void setInformalName( String m_InformalName ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_InformalName, this.m_InformalName ) ) {
            final String oldValue = this.m_InformalName;
            this.m_InformalName = m_InformalName;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_InformalName", oldValue, this.m_InformalName));
        }
    }
    private UniqueId ref_Informal_Part_ID;
    @Override
    public void setInformal_Part_ID( UniqueId ref_Informal_Part_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Informal_Part_ID.inequality( this.ref_Informal_Part_ID ) ) {
            final UniqueId oldValue = this.ref_Informal_Part_ID;
            this.ref_Informal_Part_ID = ref_Informal_Part_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Informal_Part_ID", oldValue, this.ref_Informal_Part_ID));
        }
    }
    @Override
    public UniqueId getInformal_Part_ID() throws XtumlException {
        checkLiving();
                return ref_Informal_Part_ID;
    }
    private UniqueId ref_Formal_Part_ID;
    @Override
    public UniqueId getFormal_Part_ID() throws XtumlException {
        checkLiving();
                return ref_Formal_Part_ID;
    }
    @Override
    public void setFormal_Part_ID( UniqueId ref_Formal_Part_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Formal_Part_ID.inequality( this.ref_Formal_Part_ID ) ) {
            final UniqueId oldValue = this.ref_Formal_Part_ID;
            this.ref_Formal_Part_ID = ref_Formal_Part_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Formal_Part_ID", oldValue, this.ref_Formal_Part_ID));
        }
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
                return m_Descrip;
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Descrip, this.m_Descrip ) ) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private boolean m_isFormal;
    @Override
    public boolean getIsFormal() throws XtumlException {
        checkLiving();
                return m_isFormal;
    }
    @Override
    public void setIsFormal( boolean m_isFormal ) throws XtumlException {
        checkLiving();
        if ( m_isFormal != this.m_isFormal ) {
            final boolean oldValue = this.m_isFormal;
            this.m_isFormal = m_isFormal;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_isFormal", oldValue, this.m_isFormal));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAv_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ClassInstanceParticipant R936_owns_informal_ClassInstanceParticipant_inst;
    @Override
    public void setR936_owns_informal_ClassInstanceParticipant( ClassInstanceParticipant inst ) {
        R936_owns_informal_ClassInstanceParticipant_inst = inst;
    }
    @Override
    public ClassInstanceParticipant R936_owns_informal_ClassInstanceParticipant() throws XtumlException {
        return R936_owns_informal_ClassInstanceParticipant_inst;
    }
    private ClassInstanceParticipant R937_owns_formal_ClassInstanceParticipant_inst;
    @Override
    public void setR937_owns_formal_ClassInstanceParticipant( ClassInstanceParticipant inst ) {
        R937_owns_formal_ClassInstanceParticipant_inst = inst;
    }
    @Override
    public ClassInstanceParticipant R937_owns_formal_ClassInstanceParticipant() throws XtumlException {
        return R937_owns_formal_ClassInstanceParticipant_inst;
    }
    private O_ATTR R938_references_O_ATTR_inst;
    @Override
    public void setR938_references_O_ATTR( O_ATTR inst ) {
        R938_references_O_ATTR_inst = inst;
    }
    @Override
    public O_ATTR R938_references_O_ATTR() throws XtumlException {
        return R938_references_O_ATTR_inst;
    }
    private FormalAttributeValue R948_is_a_FormalAttributeValue_inst;
    @Override
    public void setR948_is_a_FormalAttributeValue( FormalAttributeValue inst ) {
        R948_is_a_FormalAttributeValue_inst = inst;
    }
    @Override
    public FormalAttributeValue R948_is_a_FormalAttributeValue() throws XtumlException {
        return R948_is_a_FormalAttributeValue_inst;
    }
    private InformalAttributeValue R948_is_a_InformalAttributeValue_inst;
    @Override
    public void setR948_is_a_InformalAttributeValue( InformalAttributeValue inst ) {
        R948_is_a_InformalAttributeValue_inst = inst;
    }
    @Override
    public InformalAttributeValue R948_is_a_InformalAttributeValue() throws XtumlException {
        return R948_is_a_InformalAttributeValue_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InstanceAttributeValue value() {
        return this;
    }

    @Override
    public InstanceAttributeValue self() {
        return this;
    }

    @Override
    public InstanceAttributeValue oneWhere( IWhere<InstanceAttributeValue> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_INSTANCEATTRIBUTEVALUE;
    }

}

class EmptyInstanceAttributeValue extends ModelInstance<InstanceAttributeValue,Sql> implements InstanceAttributeValue {

    // attributes
    public UniqueId getAv_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAv_ID( UniqueId m_Av_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getAttr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLabel() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLabel( String m_Label ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setValue( String m_Value ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getValue() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getInformalName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInformalName( String m_InformalName ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setInformal_Part_ID( UniqueId ref_Informal_Part_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getInformal_Part_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getFormal_Part_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setFormal_Part_ID( UniqueId ref_Formal_Part_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIsFormal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIsFormal( boolean m_isFormal ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ClassInstanceParticipant R936_owns_informal_ClassInstanceParticipant() {
        return ClassInstanceParticipantImpl.EMPTY_CLASSINSTANCEPARTICIPANT;
    }
    @Override
    public ClassInstanceParticipant R937_owns_formal_ClassInstanceParticipant() {
        return ClassInstanceParticipantImpl.EMPTY_CLASSINSTANCEPARTICIPANT;
    }
    @Override
    public O_ATTR R938_references_O_ATTR() {
        return O_ATTRImpl.EMPTY_O_ATTR;
    }
    @Override
    public FormalAttributeValue R948_is_a_FormalAttributeValue() {
        return FormalAttributeValueImpl.EMPTY_FORMALATTRIBUTEVALUE;
    }
    @Override
    public InformalAttributeValue R948_is_a_InformalAttributeValue() {
        return InformalAttributeValueImpl.EMPTY_INFORMALATTRIBUTEVALUE;
    }


    @Override
    public String getKeyLetters() {
        return InstanceAttributeValueImpl.KEY_LETTERS;
    }

    @Override
    public InstanceAttributeValue value() {
        return this;
    }
    
    @Override
    public InstanceAttributeValue self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InstanceAttributeValue oneWhere( IWhere<InstanceAttributeValue> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return InstanceAttributeValueImpl.EMPTY_INSTANCEATTRIBUTEVALUE;
    }

}
